<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Color extends Model
{
    protected $fillable = [
        'color_id',
        'colorname',
        'productType',
        'fandecktype',
        'color',
        'size',
        'client_id',
        'quantity',
        'status'
    ];

    public function client()
    {
        return $this->belongsTo('App\Client');
    }

    public function productFormulation()
    {
        return $this->belongsTo('App\ProductFormulation', 'color_id', 'id');
    }
}
