<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use DateTimeInterface;

class DealerInfo extends Model
{
    protected $table = 'dealer_info';

    protected $fillable = [
        'firm_name',
        'dealer_code',
        'created_by',
        'order_limit',
        'pan_vat_no',
        'proprietor_name',
        'address',
        'latitude',
        'longitude',
        'phone_number',
        'email',
        'area_id',
        'ledger_file',
        'due_amount',
        'cheque_in_hand',
        'cheque_nos',
        'ledger_update_date',
        'created_by'
    ];

    protected $hidden = [
        'created_at',
        'updated_at',
        'token'
    ];
    public function discount()
    {
        return $this->hasMany('App\DealerDiscount', 'dealer_id');
    }
    public function dealerinfo()
    {
        return $this->belongsTo('App\DealerUser');
    }
    protected function serializeDate(DateTimeInterface $date)
    {
        return $date->format('Y-m-d H:i:s');
    }
}
