<?php

namespace App;

use Tymon\JWTAuth\Contracts\JWTSubject;
use Illuminate\Foundation\Auth\User as Authenticatable;
use DateTimeInterface;

class DealerUser extends Authenticatable implements JWTSubject
{
    //
    protected $table = 'dealer_user_info';

    protected $fillable = [
        'full_name',
        'address',
        'phone',
        'user_code',
        'dealer_id',
        'user_role',
        'status',
        'created_by',
        'password',
        'user_pass_o',
        'fcm_id',
        'device_id'
    ];


    protected $casts = [
        'created_at' => 'datetime',
        'updated_at' => 'datetime',
    ];

    protected $hidden = [
        'password',
        'user_pass_o',
        'fcm_id',
        'device_id',
        'token'
    ];

    /**
     * Get the identifier that will be stored in the subject claim of the JWT.
     *
     * @return mixed
     */
    public function getJWTIdentifier()
    {
        return $this->getKey();
    }

    /**
     * Return a key value array, containing any custom claims to be added to the JWT.
     *
     * @return array
     */
    public function getJWTCustomClaims()
    {
        return [];
    }

    public function dealer()
    {
        return $this->belongsTo(DealerInfo::class, 'dealer_id');
    }


    public function message_user()
    {
        return $this->hasMany('App\MessageGroupUser', 'user_id');
    }

    protected function serializeDate(DateTimeInterface $date)
    {
        return $date->format('Y-m-d H:i:s');
    }
}
