<?php

namespace App\Exports;

use Maatwebsite\Excel\Concerns\FromCollection;
use App\ConsumerSchemeKey;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Illuminate\Support\Facades\DB;

class ConsumerSchemeExport implements FromCollection,WithHeadings
{
    /**
    * @return \Illuminate\Support\Collection
    */
    private $id;

    public function __construct($id){
        $this->id = $id;
    }
    public function collection()
    {
        $data =  ConsumerSchemeKey::join('consumer_schemes','consumer_schemes.id','consumer_scheme_keys.consumer_scheme_id')
        ->where('consumer_scheme_id',$this->id)
        ->select('consumer_scheme_keys.id','consumer_schemes.batch','consumer_scheme_keys.key')
        ->get();
        // $key = 1;
        // foreach($data as $d){
        //     $d->id = $key;
        //     $key++;
        // }
        return $data;
    }
    public function headings(): array
    {
        return ["S/N","Batch","Numbers"];
    }
}
