<?php

namespace App\Http\Controllers\API;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Cart;
use App\Productimage;
use App\Product;
use App\ProductSize;
use App\Size;
use App\DealerInfo;
use App\DealerUser;
use App\Dealer;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Auth;
use App\DealerDiscount;

class CartController extends Controller
{
    // public function cart(Request $request)
    // {
    //     $valid = Validator::make($request->all(), [
    //         'items_id' => 'required|exists:product_size,id',
    //         'quantity' => 'required'
    //     ]);
    //     if ($valid->fails()) {
    //         return response()->json(['status' => 'error', 'message' => $valid->errors()], 422);
    //     }
    //     $dealerUser = auth()->user();
    //     $dealerId = $dealerUser->id;

    //     $productAmt = ProductSize::with('product')->select('id', 'price')->where('id', $request->items_id)->first();
    //     // $discount = DealerDiscount::where(['dealer_id' => $dealerId, 'category_id' => $productAmt['product']->category_id])->first();

    //     $cart = new Cart();
    //     $cart->user_id = $dealerId;
    //     $cart->item_id = $request->items_id;
    //     $cart->quantity = $request->quantity;
    //     $cart->price = $request->quantity * $productAmt->price;
    //     $cart->items_price_rate = $productAmt->price;
    //     $cart->save();

    //     $cart = DB::table('carts')
    //         ->join('product_size', 'carts.item_id', 'product_size.id')
    //         ->join('products', 'product_size.product_id', 'products.id')
    //         ->join('categories', 'products.category_id', 'categories.id')
    //         ->join('sizes', 'product_size.size_id', 'sizes.id')
    //         ->select('carts.id', 'product_size.id as product_id', 'products.id as pid', 'product_size.price', 'sizes.size', 'categories.name as category_name', 'products.name as product_name', 'carts.quantity')
    //         ->where('carts.user_id', $dealerId)
    //         ->get();

    //     foreach ($cart as $c) {

    //         $images = Productimage::where('product_id', $c->pid)->select('image', 'thumbnail')->get();

    //         $list[] = array(
    //             "id" => $c->id,
    //             "product_id" => $c->product_id,
    //             "price" => $c->price,
    //             "size" => $c->size,
    //             "category_name" => $c->category_name,
    //             "product_name" => $c->product_name,
    //             "quantity" => $c->quantity,
    //             "images" => $images,

    //         );
    //         $images = null;
    //     }
    //     if (!empty($list)) {
    //         return response()->json($list);
    //     } else {
    //         return response()->json([]);
    //     }
    // }

    public function cart(Request $request)
    {
        $valid = Validator::make($request->all(), [
            'items_id' => 'required|exists:product_size,id',
            'quantity' => 'required'
        ]);
        if ($valid->fails()) {
            return response()->json(['status' => 'error', 'message' => $valid->errors()], 422);
        }

        $dealerUser = auth()->user();
        $dealerId = $dealerUser->id;

        $productAmt = ProductSize::with('product')->select('id', 'price')->where('id', $request->items_id)->first();
        // $discount = DealerDiscount::where(['dealer_id' => $dealerId, 'category_id' => $productAmt['product']->category_id])->first();

        // Check if cart already has this item for the user
        $cart = Cart::where('user_id', $dealerId)->where('item_id', $request->items_id)->first();
        if ($cart) {
            // Update quantity and price
            $cart->quantity += $request->quantity;
            $cart->price = $cart->quantity * $productAmt->price;
            $cart->items_price_rate = $productAmt->price;
            $cart->save();
        } else {
            // Create new cart entry
            $cart = new Cart();
            $cart->user_id = $dealerId;
            $cart->item_id = $request->items_id;
            $cart->quantity = $request->quantity;
            $cart->price = $request->quantity * $productAmt->price;
            $cart->items_price_rate = $productAmt->price;
            $cart->save();
        }

        $cart = DB::table('carts')
            ->join('product_size', 'carts.item_id', 'product_size.id')
            ->join('products', 'product_size.product_id', 'products.id')
            ->join('categories', 'products.category_id', 'categories.id')
            ->join('sizes', 'product_size.size_id', 'sizes.id')
            ->select('carts.id', 'product_size.id as product_id', 'products.id as pid', 'product_size.price', 'sizes.size', 'categories.name as category_name', 'products.name as product_name', 'carts.quantity')
            ->where('carts.user_id', $dealerId)
            ->get();

        foreach ($cart as $c) {

            $images = Productimage::where('product_id', $c->pid)->select('image', 'thumbnail')->get();

            $list[] = array(
                "id" => $c->id,
                "product_id" => $c->product_id,
                "price" => $c->price,
                "size" => $c->size,
                "category_name" => $c->category_name,
                "product_name" => $c->product_name,
                "quantity" => $c->quantity,
                "images" => $images,

            );
            $images = null;
        }
        if (!empty($list)) {
            return response()->json($list);
        } else {
            return response()->json([]);
        }
    }

    public function getCart(Request $request)
    {
        $dealer =  auth('api')->user();
        $dealerId = $dealer->id;
        $cart = DB::table('carts')
            ->join('product_size', 'carts.item_id', 'product_size.id')
            ->join('products', 'product_size.product_id', 'products.id')
            ->join('categories', 'products.category_id', 'categories.id')
            ->join('sizes', 'product_size.size_id', 'sizes.id')
            ->select('carts.id', 'product_size.id as product_id', 'products.id as pid', 'product_size.price', 'sizes.size', 'categories.name as category_name', 'products.name as product_name', 'carts.quantity')
            ->where('carts.user_id', $dealerId)
            ->get();

        // return $cart;

        foreach ($cart as $c) {
            $images = Productimage::where('product_id', $c->pid)->select('image', 'thumbnail')->get();

            $list[] = array(
                "id" => $c->id,
                "product_id" => $c->product_id,
                "price" => $c->price,
                "size" => $c->size,
                "category_name" => $c->category_name,
                "product_name" => $c->product_name,
                "quantity" => $c->quantity,
                "images" => $images,
            );
            $images = null;
        }
        if (!empty($list)) {
            return response()->json($list);
        } else {
            return response()->json([]);
        }
    }

    public function cartEdit(Request $request, $id)
    {
        $cart = Cart::findOrFail($id);
        $cart->price = $request->quantity * $cart->items_price_rate;
        $cart->quantity = $request->quantity;
        $cart->save();

        return response()->json(
            Cart::where('user_id', $cart->user_id)->get()
        );
    }


    public function cartDelete($id)
    {
        $cart = Cart::findorFail($id);

        $cart->delete();

        $ca = DB::table('carts')
            ->join('product_size', 'carts.item_id', 'product_size.id')
            ->join('products', 'product_size.product_id', 'products.id')
            ->join('categories', 'products.category_id', 'categories.id')
            ->join('sizes', 'product_size.size_id', 'sizes.id')
            ->select('carts.id', 'product_size.id as product_id', 'products.id as pid', 'product_size.price', 'sizes.size', 'categories.name as category_name', 'products.name as product_name', 'carts.quantity')
            ->where('carts.user_id', $cart->user_id)
            ->get();

        foreach ($ca as $c) {
            $images = Productimage::where('product_id', $c->pid)->select('image', 'thumbnail')->get();

            $list[] = array(
                "id" => $c->id,
                "product_id" => $c->product_id,
                "price" => $c->price,
                "size" => $c->size,
                "category_name" => $c->category_name,
                "product_name" => $c->product_name,
                "quantity" => $c->quantity,
                "images" => $images,
            );
            $images = null;
        }
        if (!empty($list)) {
            return response()->json($list);
        } else {
            return response()->json([]);
        }
    }
}
