<?php

namespace App\Http\Controllers\API;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Clientrecord;
use App\Colorrecord;
use Illuminate\Support\Facades\Validator;
use App\Dealerinfo;

class ClientColorController extends Controller
{
    public function store(Request $request)
    {
        $valid = Validator::make($request->all(), [
            'client' => 'required|array',
            'client.*.name' => 'required',
            'client.*.address' => 'required',
            'client.*.contact' => 'required',
            'client.*.colorItem' => 'required',
            'color' => 'required|array',
            'color.*.colorName' => 'required',
            'color.*.productType' => 'required',
            'color.*.fandeckType' => 'required',
            'color.*.canSize' => 'required',
            'color.*.color' => 'required',
            'color.*.id' => 'required|numeric',

        ]);
        if ($valid->fails()) {
            return response()->json(['status' => 'error', 'message' => $valid->errors()], 422);
        }

        // $dealer = Dealerinfo::where('token', $request->bearerToken())->first();\
        $dealer = auth()->user();
        foreach ($request->color as $color) {
            // $product = Colorrecord::where('colorname',$color['colorName'])->where('productType',$color['productType'])
            // ->where('fandecktype',$color['fandeckType'])->where('size',$color['canSize'])
            // ->where('color',$color['color'])
            // ->first();
            // if(!$product){
            Colorrecord::create([
                'colorname' => $color['colorName'],
                'productType' => $color['productType'],
                'fandecktype' => $color['fandeckType'],
                'dealer_id' => $dealer->id,
                'c_id' => $color['id'],
                'size' => $color['canSize'],
                'color' => $color['color']
            ]);
        }

        foreach ($request->client as $c) {
            // return $c;
            $client = Clientrecord::where('name', $c['name'])
                // ->where('c_id', $c['id'])
                ->where('dealer_id', $dealer->id)
                ->where('address', $c['address'])
                ->where('contact', $c['contact'])
                ->first();
            if ($client) {

                $client->colorItem = $client->colorItem . ',' . $c->colorItem;
            } else {
                Clientrecord::create([
                    // 'c_id' => $c['id'],
                    'name' => $c['name'],
                    'dealer_id' => $dealer->id,
                    'address' => $c['address'],
                    'contact' => $c['contact'],
                    'coloritem' => $c['colorItem']
                ]);
            }
        }

        return response()->json(['status' => 'success', 'message' => 'Data synced successfully']);
    }
}
