<?php

namespace App\Http\Controllers\API;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Bank;
use App\Purpose;
use App\DealerInfo;
use App\Area;
use App\DealerUser;
use Illuminate\Support\Facades\hash;
use Illuminate\Support\Facades\DB;
use Tymon\JWTAuth\JWTAuth;
use Illuminate\Support\Facades\Validator;

class DealerinfoController extends Controller
{

    public function authe(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'user_code' => 'required|max:255',
            'password' => 'required',
            'device_id' => 'required',
            'fcm_id' => 'required'
        ]);
        if ($validator->fails()) {
            return response()->json(["status" => "error", 'error_code' => '422', "message" => $validator->errors()], 422);
        }


        try {
            $credentials = $request->only('user_code', 'password');
            if (!$token = auth('api')->attempt($credentials)) {
                return response()->json(['status' => 'error', 'error_code' => '401', 'message' => 'Credentials do not match', 'token' => null, 'dealer_info' => null], 401);
            } else {
                $mobileuser = DealerUser::where('user_code', $request->input('user_code'))->first();

                $u = explode('::', $mobileuser->id);
                $r = implode('', $u);
                if ($r == '219') {
                    $dealerin = $mobileuser->dealer_id;

                    $dealer = Dealerinfo::where('id', $dealerin)->first();
                    $role = $mobileuser->user_role;
                    $mobileuser->device_id = $request->input('device_id');
                    $mobileuser->fcm_id = $request->input('fcm_id');
                    $mobileuser->save();
                    return response()->json(['status' => 'success', 'error_code' => '200', 'message' => 'Welcome', 'token' => $token, 'dealer_info' => $dealer, 'Dealer_user' => $mobileuser]);
                } else {
                    $dealerin = $mobileuser->dealer_id;

                    $dealer = Dealerinfo::where('id', $dealerin)->first();
                    // $dealer = Dealer::all();
                    $roleid = explode('::', $mobileuser->user_role);
                    $role = implode("", $roleid);
                    $allowed_user_codes = ['as001', 'ps001', 'bdu001'];

                    // Convert all allowed codes to lowercase
                    $allowed_user_codes_lower = array_map('strtolower', $allowed_user_codes);

                    // if ($mobileuser->user_role == $role) {
                    if (in_array(strtolower($mobileuser->user_code), $allowed_user_codes_lower) || $mobileuser->device_id == null) {
                        $mobileuser->device_id = $request->input('device_id');
                        $mobileuser->fcm_id = $request->input('fcm_id');
                        $mobileuser->token = $token;
                        $mobileuser->save();
                        return response()->json(['status' => 'success', 'error_code' => '200', 'message' => 'Welcome', 'token' => $token, 'dealer_info' => $dealer, 'Dealer_user' => $mobileuser]);
                    } elseif ($request->input('device_id') == $mobileuser->device_id) {
                        $mobileuser->fcm_id = $request->input('fcm_id');
                        $mobileuser->token = $token;
                        $mobileuser->save();
                        return response()->json(['status' => 'success', 'error_code' => '200', 'message' => 'Welcome', 'token' => $token, 'dealer_info' => $dealer, 'Dealer_user' => $mobileuser]);
                    } else {
                        return response()->json(['status' => 'error', 'error_code' => '200', 'message' => 'User already logged in on another device', 'token' => null, 'dealer_info' => null, 'Dealer_user' => null]);
                    }
                    // } else {
                    //     // return response()->json(['status' => 'error', 'error code' => '403', 'message' => 'Access unauthorized', 'user' => null, 'banks' => [], 'purpose' => [], 'dealer' => [], 403]);
                    //     return response()->json(['status' => 'error', 'error_code' => '403', 'message' => 'Access unauthorized','token'=>null,'dealer_info'=>null,'Dealer_user'=>null], 403);
                    // }
                }
            }
        } catch (\Tymon\JWTAuth\Exceptions\TokenExpiredException $e) {

            return response()->json(['token_expired'], 500);
        } catch (\Tymon\JWTAuth\Exceptions\TokenInvalidException $e) {

            return response()->json(['token_invalid'], 500);
        } catch (\Tymon\JWTAuth\Exceptions\JWTException $e) {

            return response()->json(['token_absent' => $e->getMessage()], 500);
        }
    }

    public function ledger_info(Request $request)
    {
        $dealerUser = auth('api')->user();
        $dealerId = $dealerUser->dealer_id;

        $ledger_info = Dealerinfo::select(
            'ledger_file',
            'ledger_update_date'
        )->where('id', $dealerId)
            ->get();

        return response()->json($ledger_info);
    }
}
