<?php

namespace App\Http\Controllers\API;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Message;
use Pusher\Pusher;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Auth;
use App\MessageImages;
use App\MessageGroup;
use Illuminate\Support\Facades\DB;

class MessageController extends Controller
{
    public function userlist()
    {
        $my_id = Auth::user()->id;
        $user_id = 0;
        $individual = Message::where('type', 'individual')->where(function ($query) use ($user_id, $my_id) {
            $query->where('from', $my_id)->where('to', $user_id);
        })->orWhere(function ($query) use ($user_id, $my_id) {
            $query->where('from', $user_id)->where('to', $my_id);
        })->orderBy('created_at', 'DESC')->take(1)->get();

        $admin = new \stdClass();
        $admin->id = 0;
        $admin->group_name = env('ADMIN') ? env('ADMIN') : '';
        $admin->type = 'individual';
        $admin->created_at = count($individual) ? (string)$individual[0]->created_at : '';
        $admin->message = $individual;

        $messages = MessageGroup::whereHas('groupuser', function ($query) {
            $query->where(['message_group_users.user_id' => Auth::user()->id, 'user_type' => 'user']);
        })->with(['message' => function ($q) {
            $q->orderBy('messages.created_at', 'desc')->first();
        }])
            ->select('id', 'group_name', 'created_at', DB::raw("'group' as type"))
            ->where(['status' => 'Active'])
            ->get();
        foreach ($messages as $mes) {
            $mes->created_at = count($mes->message) > 0 ? $mes->message[0]->created_at : null;
        }
        $messages[] = $admin;
        $messages = collect($messages)->sortByDesc("created_at")->values();
        return response()->json(['status' => 'success', 'users' => $messages]);
    }

    public function send(Request $request)
    {
        $valid = Validator::make($request->all(), [
            'files' => 'nullable|array|max:5',
            'files.*' => 'file|mimes:jpg,jpeg,png,tiff|max:10280', //xlsx,xls,pdf,txt
            'user_id' => 'required|numeric'
        ]);
        if ($valid->fails()) {
            return response()->json(['status' => 'error', 'message' => $valid->errors()], 422);
        }
        if (!$request->message && count($request->files) == 0) {
            return response()->json(['status' => 'error', 'message' => "message and files cannot be empty"], 422);
        }
        $id = Auth::user();
        $from = $id->id;
        $to = 0;
        $data = new Message();

        $data->from = $from;
        $data->to = ($request->user_id == 0) ? $to : null;
        $data->message = ($request->input('message')) ? $request->input('message') : '';
        $data->is_read = 0;
        $data->groupid = ($request->user_id == 0) ? null : $request->user_id;
        $data->type = ($request->user_id == 0) ? 'individual' : 'group';
        $data->save();

        if ($request->file('files')) {
            foreach ($request->file('files') as $file) {
                $filecontent = File::get($file);
                $originalfile = $file->getClientOriginalName();
                $filename = 'messageimg/' . rand() . '_' . time() . '.' . $file->getClientOriginalExtension();
                $img = new MessageImages();
                $img->image = $filename;
                $img->chat_id = $data->id;
                $img->save();
                Storage::disk('public')->put($filename, $filecontent);
            }
        }
        $options = array(
            'cluster' => 'ap2',
            'useTLS' => true
        );

        $pusher = new Pusher(
            env('PUSHER_APP_KEY'),
            env('PUSHER_APP_SECRET'),
            env('PUSHER_APP_ID'),
            $options
        );

        $data = ['from' => $from, 'to' => $to]; // sending from and to user id when pressed enter
        $pusher->trigger('my-channel', 'my-event', $data);

        if ($request->user_id == 0) {
            $messages = Message::with(['mesaage_image', 'user', 'dealerinfo'])->where(function ($query) use ($from, $to) {
                $query->where('from', $from)->where('to', $to);
            })->orWhere(function ($query) use ($from, $to) {
                $query->where('from', $to)->where('to', $from);
            })
                ->where(['type' => $request->type])
                ->take(10)
                ->latest()
                ->get()->reverse()->values();
        } else {
            $messages = Message::with(['mesaage_image', 'user', 'dealerinfo'])
                ->where(['groupid' => $request->user_id, 'type' => 'group'])
                ->latest()
                ->take(10)
                ->get()->reverse()->values();
        }

        return response()->json(['messages' => $messages]);
    }

    public function receive(Request $request)
    {
        $valid = Validator::make($request->all(), [
            'type' => 'required|in:individual,group',
            'id' => 'required_if:type,group'
        ]);
        if ($valid->fails()) {
            return response()->json(['status' => 'error', 'message' => $valid->errors()], 422);
        }
        $id = Auth::user();
        $my_id = $id->id;
        $user_id = 0;
        if ($request->type == 'individual') {
            Message::where(['from' => $my_id, 'to' => $user_id, 'is_read' => 0])->update(['is_read' => 1]);
            $messages = Message::with(['mesaage_image', 'user', 'dealerinfo'])->where(function ($query) use ($user_id, $my_id) {
                $query->where('from', $my_id)->where('to', $user_id);
            })->orWhere(function ($query) use ($user_id, $my_id) {
                $query->where('from', $user_id)->where('to', $my_id);
            })
                ->where(['type' => $request->type])
                ->get();
        } else {
            Message::where(['groupid' => $request->id, 'is_read' => 0])->update(['is_read' => 1]);
            $messages = Message::with(['mesaage_image', 'user', 'dealerinfo'])
                ->where(['groupid' => $request->id, 'type' => $request->type])
                ->get();
        }

        return response()->json(['messages' => $messages]);
    }
}
