<?php

namespace App\Http\Controllers\API;

use App\Http\Controllers\Controller;
use App\Notice;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Auth;

class NoticeController extends Controller
{
    public function individual(Request $request)
    {
        $today = Carbon::now()->format('Y-m-d');
        $notice = Notice::where(function ($query) {
            $query->where('user_id', Auth::user()->dealer_id)
                ->orWhereNull('user_id');
        })
            ->where('publish', 1)
            ->where('date', '<=', $today)
            ->where('expiry_date', '>=', $today)
            ->orderBy('id', 'DESC')
            ->get();
        return response()->json($notice);
    }

    public function imageget(Request $request)
    {
        $userType = $request->input('type');
        $today = now();

        if (!in_array($userType, [1, 2, 3])) {
            return response()->json([
                'status' => 'error',
                'error_code' => '400',
                'message' => 'Invalid user type.'
            ]);
        }

        $query = DB::table('schemes')
            ->where('starting_from', '<=', $today)
            ->where('ending_on', '>=', $today)
            ->where('publish', 1)
            ->where('type', $userType);

        if (in_array($userType, [2, 3])) {
            $dealerId = Auth::user()->dealer_id;
            $query->where(function ($q) use ($dealerId, $userType) {
                $q->where('dealerid', $dealerId)
                    ->orWhere(function ($sub) use ($userType) {
                        $sub->whereNull('dealerid')->where('type', $userType);
                    });
            });
        }

        $titles = $query->get();

        if ($titles->isEmpty()) {
            return response()->json([
                'status' => 'success',
                'error_code' => '200',
                'updated_date' => null,
                'image_url' => []
            ]);
        }

        $latestUpdate = $titles->max('updated_at');
        $date = str_replace('::', '', $latestUpdate);


        return response()->json([
            'status' => 'success',
            'error_code' => '200',
            'updated_date' => $date,
            'image_url' => $titles
        ]);
    }
}
