<?php

namespace App\Http\Controllers\API;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Noticelog;
use App\Notice;
use Carbon\Carbon;
use Illuminate\Pagination\Paginator;
use Illuminate\Support\Collection;
use Illuminate\Pagination\LengthAwarePaginator;
use Illuminate\Support\Facades\Auth;

class NoticelogController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        $info = Auth::user();
        $today = Carbon::now()->format('Y-m-d');

        $logs = Noticelog::where('user_id', null)
            ->orWhere('user_id', $info->id)
            ->orderBy('id', 'DESC')
            ->get();

        $notices = Notice::where(function ($query) use ($info) {
            $query->where('user_id', $info->dealer_id)
                ->orWhereNull('user_id');
        })
            ->where('date', '<=', $today)
            ->where('expiry_date', '>=', $today)
            ->where('publish', 1)
            ->orderBy('id', 'DESC')
            ->get();

        foreach ($notices as $notice) {
            $notice->flag = 'notice';
        }

        foreach ($logs as $log) {
            $log->image = null;
            $log->expiry_date = null;
            $log->notice_type = null;
            $log->created_by = null;
            $publish = 0;
        }

        $data = $logs->merge($notices);
        $data = $data->sortByDesc('created_at');
        $data = $this->paginate($data);

        return response()->json($data);
    }
    public function paginate($items, $perPage = 10, $page = null, $options = [])
    {
        $page = $page ?: (Paginator::resolveCurrentPage() ?: 1);
        $items = $items instanceof Collection ? $items : Collection::make($items);
        return new LengthAwarePaginator($items->forPage($page, $perPage)->values(), $items->count(), $perPage, $page, $options);
    }
}
