<?php

namespace App\Http\Controllers\API;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\DealerInfo;
use App\Productimage;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Auth;
use App\DealerDiscount;

class ProductController extends Controller
{
    public function index()
    {
        $user = Auth::user();

        $dealer = DealerInfo::findorFail($user->dealer_id);
        $variants = DB::table('product_size')
            ->join('products', 'product_size.product_id', 'products.id')
            ->join('categories', 'products.category_id', 'categories.id')
            ->join('sizes', 'product_size.size_id', 'sizes.id')
            ->select(
                'product_size.id',
                'product_size.product_id',
                'product_size.size_id',
                'product_size.price',
                'sizes.size',
                'categories.name as category_name',
                'categories.id as category_id',
                'products.name as product_name'
            )
            ->where('product_size.status', 1)
            ->get();

        foreach ($variants as $variant) {
            $images = Productimage::where('product_id', $variant->id)->get();
            $discount = DealerDiscount::where(['category_id' => $variant->category_id, 'dealer_id' => $user->dealer_id])->first();
            if ($discount) {
                $price = $variant->price - ($variant->price * $discount->discount) / 100;
            } else {
                $price = $variant->price;
            }

            $list[] = array(
                "id" => $variant->id,
                "product_id" => $variant->product_id,
                "size_id" => $variant->size_id,
                "price" => (int) $price,
                "size" => $variant->size,
                "category_name" => $variant->category_name,
                "category_id" => $variant->category_id,
                "product_name" => $variant->product_name,
                "images" => $images,
            );
            $images = null;
        }
        $d = (int) $dealer->order_limit;
        // $list=[];
        if (!empty($list)) {
            return response()->json(['due_limit' => $d, 'items' => $list]);
        } else {
            $test = array("due_limit" => '0', "items" => null);
            return response()->json($test);
        }





        $final = DB::table('products')
            ->join('product_size', 'product_size.product_id', '=', 'products.id')
            ->select('products.id', 'products.name', 'products.category_id')
            ->where('product_size.status', '1')
            ->get();
        // return $final;

        $final = $final->unique('id');
        $final = array_slice($final->values()->all(), 0, null, true);

        return response()->json($variants);
    }
}
