<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\DealerInfo;
use App\DealerUser;
use App\Imports\Dueimport;
use Illuminate\Support\Facades\Validator;
use Maatwebsite\Excel\Facades\Excel;

class BalanceUpdateController extends Controller
{
    public function create(){
        return view('dashboards.users.updateamount');
    }
    public function update(Request $request){
        Validator::make($request->all(),[
            'file'=>'required|mimes:xlsx'
        ])->validate();

        $due = Excel::import(new Dueimport(),$request->file);

        return back()->with('Status','Dealer Balance Updated successfully');
    }
}
