<?php

namespace App\Http\Controllers;

use App\Basecolor;
use App\Noticelog;
use App\BaseTempColor;
use Illuminate\Http\Request;

class BaseColorController extends Controller
{
    public function index()
    {
        $bases = Basecolor::orderBy('id', 'desc')->paginate(25);
        return view('dashboards.basecolors.baseColors', ['bases' => $bases]);
    }

    public function update(Request $request, $id)
    {
        $request->validate([
            'unitPrice1' => 'required|numeric|min:0',
            'unitPrice2' => 'required|numeric|min:0',
            'unitPrice3' => 'required|numeric|min:0',
            'unitPrice4' => 'required|numeric|min:0',
        ]);
        // $base = Basecolor::findorFail($id);
        Basecolor::findOrFail($id)->update($request->only([
            'unitPrice1',
            'unitPrice2',
            'unitPrice3',
            'unitPrice4',
        ]));


        $temp = new BaseTempColor();
        Noticelog::create([
            'user_id' => null,
            'flag' => 'base',
            'title' => 'Base Price Update',
            'notice' => 'Base Color has been updated by Company.',
            'date' => date('Y-m-d'),
        ]);

        // $flag = "base";
        // $title = "Base color Price Updated.";
        // $content = array('Title' => 'Base color Price Updated.', 'Details' => 'Base color Price Updated.');
        // $notice = new NotificationController();
        // $notice->sendGroupNotification($title, $flag, $content);

        return back()->with('Status', 'Base color Price Updated');
    }
}
