<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\DealerInfo;
use App\Order;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Auth;
use App\LogDetail;
use App\Orderitem;
use App\Noticelog;
use App\DealerUser;
use App\Http\Controllers\NotificationController;
use App\Challan;

class ChallanController extends Controller
{

    // use Nepali_Calendar;
    public function listChallan()
    {
        $ch = DB::table('challans')->distinct()->get(['group_id']);
        if (count($ch) == 0) {
            $dealers = DealerInfo::all();
            return view('dashboards.orders.challanList', ['challans' => [], 'dealers' => $dealers]);
        } else {


            foreach ($ch as $c) {
                $challans[] = Challan::where('group_id', $c->group_id)->first();
            }
            $arr = [];
            foreach ($challans as $challan) {
                $order = Order::findorFail($challan->order_id);
                $dchln = DB::table('orders')
                    ->join('dealer_user_info', 'orders.user_id', 'dealer_user_info.id')
                    ->join('dealer_info', 'orders.dealer_code', 'dealer_info.id')
                    ->select('dealer_user_info.full_name as user_name', 'dealer_info.firm_name as dealer_name', 'dealer_info.id as dealerid', 'orders.id as group_id')
                    ->where('orders.id', $order->id)
                    ->get();
                $arr = array_merge($arr, $dchln->toArray());
            }

            $dealers = DealerInfo::all();
            return view('dashboards.orders.challanList', ['challans' => $arr, 'dealers' => $dealers]);
        }
    }

    function challan(Request $request, $id)
    {
        $mo = "";
        $o = Order::findOrFail($id);
        if ($o->status == 'completed' || $o->status == 'cancelled') {
            return redirect('/dashboard/order')->with('Status', 'Challan cannot be created for completed or cancelled orders.');
        }

        $dealerUser = DealerUser::with('dealer')->where('dealer_id', $o->dealer_code)->first();
        $dealer = $dealerUser->dealer;

        // All unique sizes in this order
        $sizes = Orderitem::where('order_id', $id)
            ->join('product_size', 'product_size.id', '=', 'orderitems.items_id')
            ->join('sizes', 'sizes.id', '=', 'product_size.size_id')
            ->select('sizes.id', 'sizes.size', 'sizes.order_index')
            ->distinct()
            ->orderBy('sizes.order_index', 'asc')
            ->pluck('sizes.size')
            ->toArray();

        // Grouped order items
        $order = Orderitem::where('order_id', $id)
            ->with(['items.product', 'items.size'])
            ->get()
            ->groupBy(fn($item) => $item->items->product_id);

        $finalData = [];

        foreach ($order as $productItems) {
            $firstItem = $productItems->first();
            $product = $firstItem->items->product;

            $sizeData = [];
            foreach ($productItems as $item) {
                $size = $item->items->size->size;
                $qty = $item->quantity;
                $amt = $qty * $item->items->price;

                if (!isset($sizeData[$size])) {
                    $sizeData[$size] = ['qty' => 0, 'amt' => 0];
                }

                $sizeData[$size]['qty'] += $qty;
                $sizeData[$size]['amt'] += $amt;
            }

            $finalData[] = [
                'product' => $product->name,
                'sizes' => $sizeData
            ];
        }

        return view('dashboards.orders.challan', [
            'sizes' => $sizes,
            'orders' => $finalData,
            'dealer' => $dealer,
            'mo' => $mo
        ]);
    }

    public function singleChallan($id)
    {
        $mo = "";
        $o = Order::findOrFail($id);

        if ($o->status == 'completed' || $o->status == 'cancelled') {
            return redirect('/dashboard/order')->with('Status', 'Challan cannot be created for completed or cancelled orders.');
        }

        $dealerUser = DealerUser::with('dealer')->where('dealer_id', $o->dealer_code)->first();
        $dealer = $dealerUser->dealer;

        // All unique sizes in this order
        $sizes = Orderitem::where('order_id', $id)
            ->join('product_size', 'product_size.id', '=', 'orderitems.items_id')
            ->join('sizes', 'sizes.id', '=', 'product_size.size_id')
            ->select('sizes.id', 'sizes.size', 'sizes.order_index')
            ->distinct()
            ->orderBy('sizes.order_index', 'asc')
            ->pluck('sizes.size')
            ->toArray();

        // Grouped order items
        $order = Orderitem::where('order_id', $id)
            ->with(['items.product', 'items.size'])
            ->get()
            ->groupBy(fn($item) => $item->items->product_id);

        $finalData = [];

        foreach ($order as $productItems) {
            $firstItem = $productItems->first();
            $product = $firstItem->items->product;

            $sizeData = [];
            foreach ($productItems as $item) {
                $size = $item->items->size->size;
                $qty = $item->quantity;
                $amt = $qty * $item->items->price;

                if (!isset($sizeData[$size])) {
                    $sizeData[$size] = ['qty' => 0, 'amt' => 0];
                }

                $sizeData[$size]['qty'] += $qty;
                $sizeData[$size]['amt'] += $amt;
            }

            $finalData[] = [
                'product' => $product->name,
                'sizes' => $sizeData
            ];
        }

        return view('dashboards.orders.challan', [
            'sizes' => $sizes,
            'orders' => $finalData,
            'dealer' => $dealer,
            'mo' => $mo
        ]);
    }

    public function challanEditView($id)
    {
        Orderitem::findorFail($id);
        $order = DB::table('orderitems')
            ->join('product_size', 'orderitems.items_id', 'product_size.id')
            ->join('products', 'product_size.product_id', 'products.id')
            ->join('sizes', 'product_size.size_id', 'sizes.id')
            ->select('orderitems.id', 'orderitems.order_id as order_id', 'products.name', 'product_size.id as productsize_id', 'sizes.size', 'product_size.price', 'orderitems.quantity')
            ->where('orderitems.id', $id)
            ->get();

        return view('dashboards.orders.edit', ['orders' => $order]);
    }

    public function challanAdd($id, Request $request)
    {
        $order = Orderitem::findorFail($id);
        $ord = Order::findorFail($order->order_id);

        $challan = new Challan();
        if ($request->quantity != $order->quantity) {
            $date = date('Y-m-d');
            $order->quantity = $request->quantity;
            $order->save();

            $ord->status = 'pending';
            $ord->save();
            return redirect('/dashboard/order')->With('Status', 'Order edit.');
        } else {
            return redirect('/dashboard/order')->with('Status', 'Challan Not Edit.');
        }
    }

    public function availability($id)
    {
        $order = Orderitem::findorFail($id);
        $ord = Order::where('id', $order->order_id)->first();
        if (count(Orderitem::where('order_id', $ord->id)->get()) == 1) {
            if ($order->status == 0) {
                $order->status = '1';
                $order->save();
                return redirect('/dashboard/order')->With('Status', 'Order Unavailable.');
            } else {
                $order->status = '0';
                $order->save();
                return redirect('/dashboard/order')->With('Status', 'Order Available');
            }
        } else {
            $o = new Order();
            if ($order->status == 0) {
                $o = new Order();

                $o->dealer_code = $ord->dealer_code;
                $o->user_id = $ord->user_id;
                // $o->tint_dealer = $ord->tint_dealer;
                // $o->tint_user = $ord->tint_user;
                // $o->tint_dealer = $ord->tint_dealer;
                $o->date = $ord->date;
                $o->status = $ord->status;
                $o->remarks = $ord->remarks;
                $o->app = $ord->app;

                $o->save();

                $newOrder = Order::where('dealer_code', $ord->dealer_code)->where('user_id', $ord->user_id)->where('date', $ord->date)->orderBy('id', 'DESC')->first();

                $item = new Orderitem();
                $item->order_id = $newOrder->id;
                $item->items_id =  $order->items_id;
                $item->quantity = $order->quantity;
                $item->quantity_update = $order->quantity;
                $item->status = 0;

                $item->save();


                $order->status = '1';
                $order->save();
                return redirect('/dashboard/order')->With('Status', 'Order Unavailable.');
            } else {
                $order->status = '0';
                $order->save();
                return redirect('/dashboard/order')->With('Status', 'Order Available');
            }
        }
    }

    public function singleChallanAdd($id)
    {
        $odr = Order::findorFail($id);
        $order = Orderitem::where('order_id', $id)->where('status', '0')->get();
        if (count($order) == 0) {
            return redirect('/dashboard/order')->with('Status', 'Product unavailable for this Order.');
        }

        $challanExists = Challan::where('order_id', $id)
            ->where('group_id', $id)
            ->exists();

        if ($challanExists) {
            return redirect('/dashboard/order/singleChallan/' . $odr->id)->with('Status', 'Challan already created for this Order.');
        } else {
            foreach ($order as $or) {
                $challan = new Challan();
                $challan->order_id = $or->order_id;
                $challan->items_id = $or->items_id;
                $challan->quantity = $or->quantity;
                $challan->group_id = $id;
                $challan->save();
            }
            $log = new LogDetail();
            $log->flag = 'order';
            $log->order_id = $odr->id;
            $log->cheque_no = $odr->cheque_num;
            $log->date = date('Y-m-d');
            $log->admin = Auth::user()->id;
            $log->user_id = $odr->user_id;
            $log->status = 'ongoing';
            $log->remarks = '';
            $log->previous_status = $odr->status;
            $log->save();

            $odr->status = 'ongoing';
            $odr->save();

            Noticelog::create([
                'user_id' => $odr->user_id,
                'flag' => 'order',
                'title' => 'Order Status Update',
                'notice' => 'Challan Created.',
                'date' => date('Y-m-d'),
            ]);

            if (!empty($otp = DealerUser::where(['id' => $odr->user_id])->first())) {
                $fcmid = $otp->fcm_id;
                $flag = "order";
                $title = "Sales Tracker";
                $detail = $odr->id;

                $content = array('Title' => 'Order Status Updated', 'Details' => 'Challan Created');
                if (!empty($fcmid)) {
                    // $notice = new NotificationController();
                }
            }

            return redirect('/dashboard/order/singleChallan/' . $odr->id);
        }
    }


    public function allChallan($id)
    {
        $o = Order::findorFail($id);
        if ($o->status == 'completed' || $o->status == 'cancelled') {
            return redirect('/dashboard/order')->with('Status', 'Challan cannot be created for completed or cancelled orders.');
        }
        $user = $o->user_id;
        $dealer = $o->dealer_code;

        $orders = DB::table('orders')
            ->join('orderitems', 'orderitems.order_id', '=', 'orders.id')
            ->select('orderitems.id', 'orderitems.order_id', 'orderitems.quantity', 'orderitems.updated_quantity', 'orders.status', 'orders.user_id', 'orderitems.items_id')
            ->where('orders.dealer_code', $dealer)
            ->where('orders.user_id', $user)
            ->where('orders.status', $o->status)
            ->where('orderitems.status', '0')
            ->get();
        if (!empty($orders)) {
            $challanExists = Challan::where('order_id', $id)
                ->where('group_id', $id)
                ->exists();

            if ($challanExists) {
                return redirect('/dashboard/order/challan/' . $o->id)->with('Status', 'Challan already created for this Order.');
            } else {
                foreach ($orders as $order) {
                    $challan = new Challan();
                    $challan->order_id = $order->order_id;
                    $challan->items_id = $order->items_id;
                    $challan->quantity = $order->quantity;
                    $challan->group_id = $id;
                    $challan->save();
                    $log = new LogDetail();
                    $log->flag = 'order';
                    $log->order_id = $order->order_id;
                    $log->cheque_no = '';
                    $log->date = date('Y-m-d');
                    $log->admin = Auth::user()->id;
                    $log->user_id = $order->user_id;
                    $log->status = 'ongoing';
                    $log->remarks = '';
                    $log->previous_status = $order->status;
                    $log->save();

                    Order::where('id', $order->order_id)->update(['status' => 'ongoing']);
                }
                Noticelog::create([
                    'user_id' => $o->user_id,
                    'flag' => 'order',
                    'title' => 'Order Status Update',
                    'notice' => 'Challan Created.',
                    'date' => date('Y-m-d'),
                ]);
                if (!empty($otp = DealerUser::where(['id' => $o->user_id])->first())) {
                    $fcmid = $otp->fcm_id;
                    $flag = "order";
                    $title = "Sales Tracker";
                    $detail = $o->id;
                    // $content = array('Title'=>'Cheque Status Updated', 'Message' => $remark, 'payment_id' =>$payment->id,'Status'=> request('status') );
                    $content = array('Title' => 'Order Status Updated', 'Details' => 'Challan Created');

                    if (!empty($fcmid)) {
                        $notice = new NotificationController();
                        // $notice->individualNotificationSend($fcmid, $title,$flag, $content);
                    }
                }

                return redirect('/dashboard/order/challan/' . $o->id);
            }
        } else {
            return redirect('/dashboard/order')->with('Status', 'Product unavailable for this Order.');
        }
    }
}
