<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Colorant;
use App\Shadecolor;
use App\Noticelog;
use App\ProductDetail;
use App\Utilities\Helpers;
use Illuminate\Support\Facades\DB;

class ColorantController extends Controller
{
    public function index()
    {
        $data['colorants'] = Colorant::paginate(20);

        return view('dashboards.colorants.colorant', $data);
    }

    public function shade()
    {
        $data['products'] = ProductDetail::whereNotNull('name')->get();

        $data['shades'] = Shadecolor::paginate(25);
        return view('dashboards.shadecolors.shade', $data);
    }

    public function shadesearch(Request $request)
    {
        if ($request->string) {
            $shades = Shadecolor::where(
                'colorCode',
                'like',
                '%' . $request->string . '%'
            )->orWhere(
                'colorName',
                'like',
                '%' . $request->string . '%'
            )->paginate(25);
        } else {
            $shades = Shadecolor::paginate(25);
        }

        $data['products'] = ProductDetail::whereNotNull('name')->get();
        $data['shades'] = $shades;

        return view('dashboards.shadecolors.table', $data);
    }

    public function update(Request $request)
    {
        $request->validate([
            'price' => 'required|array',
            'price.*' => 'required|numeric|min:0',
        ]);

        $data = Colorant::get();

        foreach ($data as $key => $d) {
            $d->unitPrice = $request->price[$key];
            $d->save();
        }

        //NoticeLog
        Noticelog::create([
            'user_id' => null,
            'flag' => 'colorant',
            'title' => 'Colourant Price Update',
            'notice' => 'Colourant Price has been updated by Company.',
            'date' => date('Y-m-d'),
        ]);

        $data = [
            'route_channel' => 'colorant',
            'file_path' => null,
        ];

        $title = $colorant->title ?? 'Colorant Price Update';
        $body = $colorant->description ?? 'Colourant Price has been updated by Company.';

        $helpers = new Helpers;

        $helpers->runFirebaseNotification(null, 'all', $title, $body, $data);
        // }

        return back()->with('Status', 'Colourant Price Updated');
    }
}
