<?php

namespace App\Http\Controllers;

use App\ConsumerScheme;
use App\ConsumerSchemeKey;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Str;

class ConsumerSchemeController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $scheme = ConsumerScheme::paginate(30);

        return view('dashboards.consumerscheme.list',['consumerschemes'=>$scheme]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('dashboards.consumerscheme.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->validate($request,[
            'batch'=>'required|alpha_dash|max:32',
            'datetime'=>'required|date_format:Y-m-d',
            'no_of_key' => 'required|numeric|max:1000'
        ]);
        $scheme = ConsumerScheme::where('batch',$request->batch)->first();
        if(!$scheme){
        $scheme = new ConsumerScheme();

        $scheme->batch = $request->batch;
        $scheme->datetime = \Carbon\Carbon::now();
        $scheme->no_of_key = $request->no_of_key;
        }else{
            $scheme->no_of_key = $scheme->no_of_key+$request->no_of_key;
        }
        if($scheme->save()){
            $count = 0;
            $min = 100000;
            $max = 999999;
            for($i=0;$i<$request->no_of_key;$i++){

                $key = $this->uniqueRandom($min,$max,$count);
                if(ConsumerSchemeKey::where('key',$key)->first()){
                    $key = $this->uniqueRandom($min,$max,$count);
                }
                $data[] = array(
                    'consumer_scheme_id'=>$scheme->id,
                    'key' =>$key,
                    'created_at' => \Carbon\Carbon::now(),
                    'status' => "In Stock",
                    'updated_at' => \Carbon\Carbon::now()
                );
                $count++;
            }
            ConsumerSchemeKey::insert($data);
            Session::flash('Status',"Data Added successfully");
            return redirect("/dashboard/consumerscheme");
        }else{
            Session::flash('warning',"Data store Process cancelled");
            return back();
        }
    }
    private function uniqueRandom($min,$max,$count){
        $strlen = strlen($count);
        // $key = Str::random(8-$strlen).$count;
        $key = mt_rand($min,$max);


        if($strlen==1){
            $count = '0'.$count;
        }
        $key = $key.$count;
        return $key;
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\ConsumerScheme  $consumerScheme
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $key = ConsumerSchemeKey::where('consumer_scheme_id',$id)->paginate(30);

        return view('dashboards.consumerscheme.key',['keys'=>$key]);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\ConsumerScheme  $consumerScheme
     * @return \Illuminate\Http\Response
     */
    public function edit(ConsumerScheme $consumerScheme)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\ConsumerScheme  $consumerScheme
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, ConsumerScheme $consumerScheme)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\ConsumerScheme  $consumerScheme
     * @return \Illuminate\Http\Response
     */
    public function destroy(ConsumerScheme $consumerScheme)
    {
        //
    }
    public function printview(Request $request,$id){
        $key = ConsumerSchemeKey::where('consumer_scheme_id',$id)->paginate(120);
        if(count($key)>0){
            return view('dashboards.consumerscheme.printview',['keys'=>$key]); 
        }else{
            Session::flash('Status','No Preview Available');
            return redirect('/dashboard/consumerscheme');
        }
    }
}
