<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\DealerUser;
use App\DealerInfo;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Validator;
use App\Noticelog;
use App\Category;
use App\DealerDiscount;
use Illuminate\Support\Facades\Session;

class DealerUserInfoController extends Controller
{

    public function index()
    {
        $category = Category::all();
        return view('dashboards.users.addMobileUser', ['categories' => $category]);
    }


    public function addMobileUser(Request $request)
    {
        // DealerInfo and DealerUser table must have same dealer_code. In DealerUser table, dealer_code is user_code.
        $this->validate($request, [
            'fname' => 'required',
            'lname' => 'required',
            'dealer' => 'nullable',
            'code' => 'nullable',
            'user_code' => 'required|unique:dealer_user_info',
            'address' => 'required',
            'phone' => 'required|digits_between:9,10|unique:dealer_user_info,phone',
            'password' => 'required|confirmed|max:255|min:6',
            'role' => 'required|integer|in:1,2,3',
            'limit' => 'nullable|numeric',
            'product_name' => 'nullable|array',
            'product_name.*' => 'nullable|exists:categories,id',
            'discount' => 'nullable|array',
            'discount.*' => 'nullable|min:0|max:100|numeric',
        ]);

        $id = (string) Auth::user()->id;

        // Handle dealer info and user creation based on role
        if ($request->role == 3) {
            $dealerInfo = DealerInfo::firstOrCreate(
                ['dealer_code' => env('company_code')],
                [
                    'firm_name' => env('company_name'),
                    'created_by' => $id,
                    'order_limit' => 0,
                    'cheque_in_hand' => 0,
                    'due_amount' => 0,
                    'cheque_nos' => 0
                ]
            );
            $dealeruser = DealerUser::create([
                'full_name' => $request->fname . ' ' . $request->lname,
                'address' => $request->address,
                'phone' => $request->phone,
                'user_code' => $request->user_code,
                'user_pass_o' => $request->password,
                'password' => Hash::make($request->password),
                'dealer_id' => $dealerInfo->id,
                'user_role' => $request->role,
                'status' => '1',
                'created_by' => $id
            ]);

            return redirect('/dashboard/companystaff')->with('Status', 'Company Staff is Created.');
        }

        // For roles other than 3, validate dealer code and create a new dealer if needed
        $dealerInfo = DealerInfo::where('dealer_code', $request->user_code)->first();

        if (!$dealerInfo) {
            $dealerInfo = new DealerInfo();
            $dealerInfo->fill([
                'firm_name' => $request->dealer,
                'address' => $request->address,
                'phone_number' => $request->phone,
                'proprietor_name' => $request->fname . " " . $request->lname,
                'dealer_code' => $request->user_code,
                'created_by' => $id,
                'order_limit' => $request->role == 2 ? 0 : $request->limit
            ]);
            $dealerInfo->save();

            // Create discounts if provided
            if ($request->discount) {
                foreach ($request->discount as $key => $discount) {
                    if ($discount !== null) {
                        DealerDiscount::create([
                            'category_id' => $request->product_name[$key],
                            'dealer_id' => $dealerInfo->id,
                            'discount' => $discount
                        ]);
                    }
                }
            }
        }

        // Create the dealer user
        $dealeruser = DealerUser::create([
            'full_name' => $request->fname . ' ' . $request->lname,
            'address' => $request->address,
            'phone' => $request->phone,
            'user_code' => $request->user_code,
            'user_pass_o' => $request->password,
            'password' => Hash::make($request->password),
            'dealer_id' => $dealerInfo->id,
            'user_role' => $request->role,
            'status' => '1',
            'created_by' => $id
        ]);

        //For Created Dealer user Synce to painter app.
        // $dealers = DealerInfo::where('id', $dealerInfo->id)->get();
        // $dealeruser = DealerUser::where('id', $dealeruser->id)->get();

        $dealers = DealerInfo::where('sync', 0)->where('id', $dealerInfo->id)
            ->select(
                'dealer_code',
                'firm_name as dealer_name',
                'proprietor_name as name',
                'phone_number as contact',
                'address as address1',
                'area_id as area_code',
                'pan_vat_no as pan_vat',
                'email',
                'latitude',
                'longitude',
                'created_at',
                'updated_at',
                'order_limit'
            )
            ->get();
        $dealeruser = DealerUser::where('sync', 0)->where('id', $dealeruser->id)
            ->select(
                'id',
                'full_name',
                'address',
                'phone',
                'user_code',
                'password',
                'user_code as dealer_id',
                'user_role',
                'status',
                'fcm_id',
                'device_id',
                'created_at',
                'updated_at'
            )
            ->get();

        // $url = "https://rajdoot.bpainter.in/api/dealersync";
        $url = "https://rajdoot.bpainter.in/api/dealersync";
        $client = new \GuzzleHttp\Client();
        $reqbody['dealers'] = $dealers;
        $reqbody['dealerusers'] = $dealeruser;
        $reqbody['areas'] = $areas ?? [];
        $reqbody['subareas'] = $subareas ?? [];
        $reqbody['areaassign'] = $areaassign ?? [];
        $reqbody['auth_key'] = "ElNnxnOha82S1lpsILN4OngBzgImLYADNUNhE91zy9nmLYvw4TTHHQpMzuXGfFLZ";

        if (isset($url)) {
            try {
                $response = $client->request('POST', $url, [
                    'json' => $reqbody
                ]);
                // dd($response->getBody()->getContents());
                $resvalue = json_decode($response->getBody()->getContents());
                if ($response->getStatusCode() == 200 && $resvalue->message == "dealer synced") {
                    DealerInfo::where('sync', 0)->update(['sync' => 1]);
                    DealerUser::where('sync', 0)->update(['sync' => 1]);
                    Session::flash('Status', 'Dealer User Created And Sync successfully');
                    return back();
                }
            } catch (\GuzzleHttp\Exception\ServerException $e) {
                $response = $e->getResponse();
                return $response->getBody();
                Session::flash('Status', 'Dealer Sync failed please try again later');
                return back();
            }
        }

        if ($request->role == 2) {
            return redirect('/dashboard/staffonDealer')->with('Status', 'Staff on Dealer Created');
        }

        return redirect('/dashboard/mobileUser')->with('Status', 'Dealer User Created');
    }

    public function dealers()
    {
        $dealers = DB::table('dealer_user_info')
            ->join('dealer_info', 'dealer_user_info.dealer_id', 'dealer_info.id')
            ->where('user_role', '1')
            ->where('status', '1')
            ->select('dealer_user_info.*', 'dealer_info.firm_name', 'dealer_info.due_amount', 'dealer_info.dealer_code', 'dealer_info.cheque_in_hand', 'dealer_info.cheque_nos', 'dealer_info.order_limit')
            ->get();
        // dd($dealers);
        return view('dashboards.users.showDealers', ['dealers' => $dealers]);
    }


    public function staffOnDealers()
    {
        // $dealers = DealerUser::where('user_role','2')->get();
        $dealers = DB::table('dealer_user_info')
            ->join('dealer_info', 'dealer_user_info.dealer_id', 'dealer_info.id')
            ->where('user_role', '2')
            ->where('status', '1')
            ->select('dealer_user_info.*', 'dealer_info.firm_name', 'dealer_info.dealer_code')
            ->get();
        return view('dashboards.users.showStaffonDealers', ['dealers' => $dealers]);
    }


    public function edit($id)
    {
        $dealer = DealerUser::findorFail($id);
        $dealers = Dealerinfo::findorFail($dealer->dealer_id);
        return view('dashboards.users.mobileUserEdit', ['dealer' => $dealer, 'dealers' => $dealers]);
    }


    public function update($id, Request $request)
    {
        // dd('sss');
        $valid = Validator::make($request->all(), [
            'phone' => 'required|digits_between:9,10',
            'name' => 'required|max:191',
            'address' => 'required|max:191',
        ]);
        if ($valid->fails()) {
            return back()->with('Status', 'Something went wrong');
        }

        // return $uid = (string) Auth::User()->id;
        $dealer = DealerUser::findorFail($id);
        if ($dealer->user_code != $request->user_code) {
            $valid = Validator::make($request->all(), [
                'user_code' => 'required|unique:dealer_user_info',
                'phone' => 'required|digits_between:9,10',
            ]);
            if ($valid->fails()) {
                return back()->with('Status', 'Something went wrong');
            }
        }

        // $dealerinfo = DealerInfo::where('id',$dealer->dealer_id)->first();
        $dealer->full_name = $request->name;
        $dealer->user_code = $request->user_code;
        $dealer->address = $request->address;
        $dealer->phone = $request->phone;
        // $dealerinfo->created_by = $uid;
        // $dealerinfo->save();

        $firm = Dealerinfo::findorFail($dealer->dealer_id);
        if ($dealer->user_role == 1) {
            // $firm->order_limit = $request->limit;
            $firm->firm_name = $request->firm_name;
        }
        $firm->save();


        $dealer->save();
        if ($dealer->user_role == '1') {
            return redirect('/dashboard/mobileUser')->with('Status', 'Dealer Updated');
        }
        if ($dealer->user_role == '2') {
            return redirect('/dashboard/staffonDealer')->with('Status', 'Dealer User Updated.');
        }
        if ($dealer->user_role == '3') {
            return redirect('/dashboard/companystaff')->with('Status', 'Company Staff Updated.');
        }
    }


    public function delete($id)
    {
        $dealer = DealerUser::findorFail($id);
        $dealer->status = '0';
        $dealer->save();
        if ($dealer->user_role == '1') {
            return redirect('/dashboard/mobileUser')->with('Status', 'User Deleted');
        } else {
            return redirect('/dashboard/staffonDealer')->with('Status', 'User Deleted.');
        }
    }


    public function reset($id)
    {
        $dealer = DealerUser::findorFail($id);

        $dealer->device_id = null;
        $dealer->fcm_id = null;
        $dealer->save();
        return redirect('/dashboard/mobileUser')->with('Status', 'Device Reset.');
    }
    public function resetStaff($id)
    {
        $dealer = DealerUser::findorFail($id);

        $dealer->device_id = null;
        $dealer->fcm_id = null;
        $dealer->save();
        return back()->with('Status', 'Device Reset.');
    }


    public function chequeinHand(Request $request, $id)
    {
        $dealer = DealerUser::findorFail($id);
        $dealerid = $dealer->dealer_id;

        $info = DealerInfo::findorFail($dealerid);

        $info->cheque_in_hand = $request->handamt;

        $otp = DealerUser::where('id', $id)->first();
        $fcmid = $otp->fcm_id;
        if ($fcmid) {
            $title = "Cheque in Hand";
            $flag = 'chequeAndDue';
            $detail = "Cheque in Hand amount Updated.";
            $content = array('Title' => 'Cheque in Hand amount Updated.', 'Details' => 'Cheque in Hand amount Updated.');
            $notice = new NotificationController();
            // $notice->individualNotificationSend($fcmid, $title, $flag, $content);
        }
        Noticelog::create([
            'user_id' => $id,
            'flag' => 'chequeAndDue',
            'title' => 'Cheque in Hand amount Updated.',
            'notice' => 'Cheque in Hand amount Updated.',
            'date' => date('Y-m-d'),
        ]);
        $info->save();
        return redirect('/dashboard/mobileUser');
    }

    public function due(Request $request, $id)
    {
        $dealer = DealerUser::findorFail($id);
        $dealerid = $dealer->dealer_id;

        $info = DealerInfo::findorFail($dealerid);

        $info->due_amount = $request->due;

        $otp = DealerUser::where('id', $id)->first();
        $fcmid = $otp->fcm_id;
        if ($fcmid) {
            $title = "Due Amount";
            $flag = 'chequeAndDue';
            $detail = "Due amount Updated.";
            $content = array('Title' => 'Due amount Updated.', 'Details' => 'Due amount Updated.');
            $notice = new NotificationController();
            // $notice->individualNotificationSend($fcmid, $title, $flag, $content);
        }
        Noticelog::create([
            'user_id' => $id,
            'flag' => 'chequeAndDue',
            'title' => 'Due amount Updated..',
            'notice' => 'Due amount Updated..',
            'date' => date('Y-m-d'),
        ]);
        $info->save();
        return redirect('/dashboard/mobileUser');
    }

    public function cheque(Request $request, $id)
    {
        $dealer = DealerUser::findorFail($id);
        $dealerid = $dealer->dealer_id;

        $info = DealerInfo::findorFail($dealerid);

        $info->cheque_nos = $request->cheque;

        $otp = DealerUser::where('id', $id)->first();
        $fcmid = $otp->fcm_id;
        if ($fcmid) {
            $title = "Cheque numbers";
            $flag = 'chequeAndDue';
            $detail = "Cheque numbers Updated.";
            $content = array('Title' => 'Cheque numbers Updated.', 'Details' => 'Cheque numbers Updated.');
            $notice = new NotificationController();
            // $notice->individualNotificationSend($fcmid, $title, $flag, $content);
        }
        Noticelog::create([
            'user_id' => $id,
            'flag' => 'chequeAndDue',
            'title' => 'Cheque numbers Updated.',
            'notice' => 'Cheque numbers Updated.',
            'date' => date('Y-m-d'),
        ]);
        $info->save();
        return redirect('/dashboard/mobileUser');
    }

    public function companystaff()
    {
        $dealers = DB::table('dealer_user_info')
            ->join('dealer_info', 'dealer_user_info.dealer_id', 'dealer_info.id')
            ->where('user_role', '3')
            ->where('status', '1')
            ->select('dealer_user_info.*', 'dealer_info.firm_name')
            ->get();
        return view('dashboards.users.showCompanyStaff', ['dealers' => $dealers]);
    }

    public function dealersync()
    {
        $dealers = DealerInfo::where('sync', 0)
            ->select(
                'dealer_code',
                'firm_name as dealer_name',
                'proprietor_name as name',
                'phone_number as contact',
                'address as address1',
                'area_id as area_code',
                'pan_vat_no as pan_vat',
                'email',
                'latitude',
                'longitude',
                'created_at',
                'updated_at',
                'order_limit'
            )
            ->get();
        $dealeruser = DealerUser::where('sync', 0)
            ->select(
                'id',
                'full_name',
                'address',
                'phone',
                'user_code',
                'password',
                'user_code as dealer_id',
                'user_role',
                'status',
                'fcm_id',
                'device_id',
                'created_at',
                'updated_at'
            )
            ->get();


        // $url = "https://rajdoot.bpainter.in/api/dealersync";
        $url = "https://rajdoot.bpainter.in/api/dealersync";
        $client = new \GuzzleHttp\Client();
        $reqbody['dealers'] = $dealers;
        $reqbody['dealerusers'] = $dealeruser;
        $reqbody['areas'] = $areas ?? [];
        $reqbody['subareas'] = $subareas ?? [];
        $reqbody['areaassign'] = $areaassign ?? [];
        $reqbody['auth_key'] = "ElNnxnOha82S1lpsILN4OngBzgImLYADNUNhE91zy9nmLYvw4TTHHQpMzuXGfFLZ";
        // return $reqbody;
        // return  $request = $client->post($url,['body'=>$reqbody]);

        // $request->send();
        if (isset($url)) {
            try {
                $response = $client->request('POST', $url, [
                    'json' => $reqbody
                ]);
                // dd($response->getBody()->getContents());
                $resvalue = json_decode($response->getBody()->getContents());
                if ($response->getStatusCode() == 200 && $resvalue->message == "dealer synced") {
                    DealerInfo::where('sync', 0)->update(['sync' => 1]);
                    DealerUser::where('sync', 0)->update(['sync' => 1]);
                    Session::flash('Status', 'Dealer User Created And Sync successfully');
                    return back();
                }
            } catch (\GuzzleHttp\Exception\ServerException $e) {
                $response = $e->getResponse();
                return $response->getBody();
                Session::flash('Status', 'Dealer Sync failed please try again later');
                return back();
            }
        } else {
            Session::flash('Status', 'No Dealer or Dealer user to sync');
            return back();
        }
    }
}
