<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Exports\ProductExport;
use App\Exports\DealerExport;
use App\Imports\UpdateProductExcel;
use Maatwebsite\Excel\Facades\Excel;
use App\Http\Controllers\NotificationController;


class ExcelController extends Controller
{
    public function export()
    {
        if (ob_get_contents()) ob_end_clean();
        ob_start();
        return Excel::download(new ProductExport, 'product.xlsx');
    }
    public function excelUpdate(Request $request)
    {
        $this->validate($request, [
            'excel_file' => 'required|file|mimes:xlsx',
        ]);
        $file = $request->file('excel_file');
        Excel::import(new UpdateProductExcel, $file);


        $title = 'Product Price Updated';
        $flag = 'product';
        $content = array('Title' => 'Product Price Updated', 'Details' => 'Product Price Updated.');

        $notice = new NotificationController();
        //  $notice->sendGroupNotification($flag, $title, $content);

        return redirect('/dashboard/products')->with('Status', 'Product Price Updated.');
    }
    public function dealerexport()
    {
        ob_end_clean();
        ob_start();
        return Excel::download(new DealerExport, 'dealer.xlsx');
    }
    public function dealerExcelUpdate(Request $request)
    {
        $this->validate($request, [
            'excel_file' => 'required|file|mimes:xlsx',
        ]);
        $file = $request->file('excel_file');
        Excel::import(new UpdateProductExcel, $file);


        $title = 'Product Price Updated';
        $flag = 'product';
        $content = array('Title' => 'Product Price Updated', 'Message' => 'Product Price Updated.');

        $notice = new NotificationController();
        //  $notice->sendGroupNotification($flag, $title, $content);

        return redirect('/dashboard/products')->with('Status', 'Product Price Updated.');
    }
}
