<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\DealerInfo;
use App\DealerUser;
use App\Category;
use App\DealerDiscount;
// use App\Area;
// use App\Subarea;
// use App\Assignarea;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\DB;

class FirmController extends Controller
{
    public function index()
    {
        $firm = DealerInfo::all();
        return view('dashboards.firms.firm', ['firms' => $firm]);
    }
    public function show($id)
    {
        $dealers = DealerUser::join('dealer_info', 'dealer_user_info.dealer_id', 'dealer_info.id')
            ->where('user_role', '1')
            ->where('dealer_info.id', $id)
            ->select('dealer_user_info.*', 'dealer_info.firm_name', 'dealer_info.dealer_code', 'dealer_info.due_amount', 'dealer_info.cheque_in_hand', 'dealer_info.cheque_nos', 'dealer_info.order_limit')
            ->get();
        return view('dashboards.users.showDealers', ['dealers' => $dealers, 'firmid' => $id]);
    }
    public function edit($id)
    {
        $firm = DealerInfo::with('discount')->findorFail($id);
        $category = Category::all();

        return view('dashboards.firms.edit', ['firm' => $firm, 'categories' => $category]);
    }
    public function update(Request $request, $id)
    {
        $valid = Validator::make($request->all(), [
            'firm_name' => 'required|string|max:191',
            'address' => 'required|string|max:191',
            'phone' => 'required',
            'limit' => 'required|numeric|min:0',
            'product_name.*' => 'nullable|exists:categories,id',
            'discount.*' => 'nullable|min:0|max:100|numeric',
        ]);
        if ($valid->fails()) {
            return back()->with('Status', 'Somethig went Wrong, please Try Again');
        }
        $firm = DealerInfo::findorFail($id);

        if ($firm->phone_number != $request->phone) {
            $valid = Validator::make($request->all(), [
                'phone' => 'unique:dealer_info,phone_number',
            ]);
            if ($valid->fails()) {
                return back()->with('Status', 'Somethig went Wrong, please Try Again');
            }
        }
        $firm->firm_name = $request->firm_name;
        $firm->address = $request->address;
        $firm->phone_number = $request->phone;
        $firm->order_limit = $request->limit;

        $firm->save();
        if ($request->discount) {
            foreach ($request->discount as $key => $discount) {
                $discountProduct = DealerDiscount::where(['category_id' => $request->product_name[$key], 'dealer_id' => $firm->id])->first();
                if (!$discountProduct) {
                    if ($discount != null) {
                        $discountProduct = new DealerDiscount();
                        $discountProduct->category_id = $request->product_name[$key];
                        $discountProduct->dealer_id = $firm->id;
                        $discountProduct->discount = $discount;

                        $discountProduct->save();
                    }
                } else {
                    // $discountProduct->category_id = $request->product_name[$key];
                    // $discountProduct->dealer_id = $firm->id;
                    $discountProduct->discount = $discount;

                    $discountProduct->save();
                }
            }
        }

        return back()->with('Status', 'Successfully Updated.');
    }
    public function dealers()
    {
        $dealers = DB::table('dealer_user_info')
            ->join('dealer_info', 'dealer_user_info.dealer_id', 'dealer_info.id')
            ->where('user_role', '1')
            // ->where('status','1')
            ->select('dealer_user_info.*', 'dealer_info.name as firm_name', 'dealer_info.due_amount', 'dealer_info.cheque_in_hand', 'dealer_info.cheque_nos', 'dealer_info.order_limit')
            ->get();
        return view('dashboards.users.showDealers', ['dealers' => $dealers]);
    }


    public function staffOnDealers($id)
    {
        // $dealers = DealerUser::where('user_role','2')->get();
        $dealers = DealerUser::join('dealer_info', 'dealer_user_info.dealer_id', 'dealer_info.id')
            ->where('user_role', '2')
            // ->where('dealer_info.code',$id)
            ->select('dealer_user_info.*', 'dealer_info.firm_name', 'dealer_info.dealer_code')
            ->get();
        return view('dashboards.users.showStaffonDealers', ['dealers' => $dealers, 'firmid' => $id]);
    }
}
