<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\DealerUser;
use App\DealerInfo;
use App\Noticelog;

class LedgerController extends Controller
{
    public function index()
    {
        $dealers = DealerInfo::where('ledger_file', '!=', null)->get();

        return view('dashboards.others.ledger', ['dealers' => $dealers]);
    }

    public function update(Request $request, $id)
    {
        $request->validate([
            'cheque_in_hand' => 'required|min:0|numeric',
            'due_amount' => 'required|min:0|numeric',
            'number_of_cheque_in_hand' => 'required|min:0|numeric',
        ]);

        $firm = DealerInfo::findorFail($id);
        if (
            $firm->cheque_in_hand == $request->cheque_in_hand
            && $firm->due_amount == $request->due_amount
            && $firm->cheque_nos == $request->number_of_cheque_in_hand
        ) {
            return back()->with('Status', ' Passed all Previous data');
        }
        $firm->cheque_in_hand = $request->cheque_in_hand;
        $firm->due_amount = $request->due_amount;
        $firm->cheque_nos = $request->number_of_cheque_in_hand;
        $firm->save();
        $tokens = DealerUser::pluck('fcm_id')->where('dealer_id', $id)->toArray();
        if (count($tokens) > 0) {
            $title = "Statement Updated";
            $flag = 'chequeAndDue';
            $detail = "Statement Updated.";
            $content = array('Title' => 'Statement Updated.', 'Details' => 'Statement Updated.');
            $notice = new NotificationController();
            // $notice->individualNotificationSend($tokens, $title, $flag, $content);
        }
        Noticelog::create([
            'user_id' => $id,
            'flag' => 'chequeAndDue',
            'title' => 'Dealer Statement Updated.',
            'notice' => 'Dealer Statement Updated.',
            'date' => date('Y-m-d'),
        ]);

        return back()->with('Status', ' Statement Updated');
    }

    public function destroy($id)
    {
        $dealer = DealerInfo::findorFail($id);
        $dealer->ledger_file = null;
        $dealer->ledger_update_date = null;

        $dealer->save();

        return back()->with('Status', 'Ledger Deleted....');
    }
}
