<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\File;
use App\Message;
use App\User;
use App\DealerUser;
use Pusher\Pusher;
use App\MessageImages;
use App\MessageGroup;
use App\MessageGroupUser;

class MessageController extends Controller
{
    public function index()
    {
        $individual = [];
        $group = [];
        $user1 = Message::where([['from', '!=', 0], 'type' => 'individual'])->distinct()->pluck('from')->toArray();
        $user2 = Message::select('to')->where([['to', '!=', 0], 'type' => 'individual'])->distinct()->pluck('to')->toArray();
        $users = array_unique(array_merge($user1, $user2));
        $users = collect($users)->values();
        foreach ($users as $user) {
            $dealeruser = DealerUser::select('id', 'full_name')->where('id', $user)->first();
            $mess = Message::where(['type' => 'individual'])->where(function ($query) use ($user) {
                $query->where('from', $user)->orWhere('to', $user);
            })
                ->select('messages.id as message_id', 'message', 'is_read', 'created_at')->orderBy('created_at', 'DESC');
            $messagedata = $mess->first();
            $dealeruser->message = $messagedata;
            $dealeruser->unread = $mess->where([['from', '!=', 0], 'is_read' => 0])->count();
            $dealeruser->created_at = $messagedata->created_at;
            $dealeruser->type = 'individual';
            $individual[] = $dealeruser;
            $messagedata = '';
        }
        $messages = MessageGroup::whereHas('groupuser', function ($query) {
            $query->where(['message_group_users.user_id' => Auth::user()->id, 'user_type' => 'admin']);
        })->select('id', 'group_name as full_name')->where('status', 'Active')->get();
        foreach ($messages as $mes) {
            $mess = Message::where(['type' => 'group', 'groupid' => $mes->id])
                ->select('messages.id as message_id', 'message', 'created_at')->orderBy('created_at', 'DESC');
            $groupmsg = $mess->first();
            $mes->unread = $mess->where([['from', '!=', 0], 'is_read' => 0])->count();
            $mes->created_at = $groupmsg ? $groupmsg->created_at : $mes->created_at;
            $mes->message = $groupmsg;
            $mes->type = 'group';
            $group[] = $mes;
            $groupmsg = '';
        }
        $list = collect(array_merge($individual, $group))->sortByDesc('created_at')->values();
        // dd($list[0]);
        // return view('dashboards.chat.users',['users'=>$list]);
        return view('dashboards.chat.chats', ['users' => $list]);


        // select all users except logged in user
        // $users = User::where('id', '!=', Auth::id())->get();
        // return view('home',['users'=>$users]);

        // count how many message are unread from the selected user
        // $users = DB::select("select dealer_user_info.id, dealer_user_info.full_name, count(is_read) as unread
        //   from dealer_user_info LEFT  JOIN  messages ON dealer_user_info.id = messages.from and is_read = 0
        //   group by dealer_user_info.id, dealer_user_info.full_name");
        //   $users = Message::join('dealer_user_info',function($join){
        //     $join->on('dealer_user_info.id','messages.from')
        //     ->on('dealer_user_info.id','messages.to');
        //   })
        // ->select('messages.*','dealer_user_info.full_name')
        // ->get();
        // $users1 = Message::join('dealer_user_info as u1','u1.id','messages.from')
        // // ->join('dealer_user_info as u2','u2.id','messages.to')
        // ->select('messages.*','u1.full_name')
        // ->get()->toArray();
    }

    public function getMessage(Request $request, $user_id)
    {
        $this->validate($request, [
            'type' => 'required|in:individual,group'
        ]);
        // $my_id = Auth::id();
        $my_id = 0;

        // Make read all unread message
        if ($request->type == 'individual') {
            Message::where(['type' => $request->type, 'from' => $user_id, 'to' => $my_id])->update(['is_read' => 1]);

            // Get all message from selected user
            $messages = Message::where('type', $request->type)->where(function ($query) use ($user_id, $my_id) {
                $query->where('from', $my_id)->where('to', $user_id);
            })->orWhere(function ($query) use ($user_id, $my_id) {
                $query->where('from', $user_id)->where('to', $my_id);
            })->get();
            // return $messages;

            $user = DealerUser::where('id', $user_id)->first();
        } else {
            Message::where(['type' => $request->type, 'groupid' => $user_id])->update(['is_read' => 1]);
            $user = MessageGroup::select('id', 'group_name as full_name')->where('id', $user_id)->first();
            $messages = Message::where('groupid', $user->id)->get();
        }
        foreach ($messages as $message) {
            if ($message->admin != null) {
                $u = User::where('id', $message->admin)->first();
                if ($u) {
                    $message->admin = $u->name;
                } else {
                    $message->admin = '';
                }
            } else {
                $dealeruser = DealerUser::select('full_name')->where('id', $message->from)->first();
                $message->admin = $dealeruser->full_name;
            }
        }
        // return $messages;
        return view('dashboards.chat.create', ['messages' => $messages, 'user' => $user]);
    }

    public function sendMessage(Request $request)
    {
        $valid = Validator::make($request->all(), [
            'files' => 'array|max:5',
            'files.*' => 'mimes:jpg,jpeg,png,tiff|max:10240', //xlsx,xls,pdf,txt
            'receiver_id' => 'required',
            'type' => 'required|in:individual,group'
        ]);
        if ($valid->fails()) {
            return response()->json(['status' => 'error', 'message' => $valid->errors()], 422);
        }
        $admin = Auth::user()->id;
        $from = 0;
        $to = $request->receiver_id;
        $type = $request->type;
        $message = $request->message;
        if ($message == '') {
            $message = '';
        }
        $data = new Message();
        $data->from = $from;
        if ($request->type == 'individual') {
            $data->to = $to;
        } else {
            $data->to = null;
        }
        $data->message = $message;
        $data->admin = $admin;
        $data->is_read = 0; // message will be unread when sending message
        $data->type = $type;
        if ($type == 'group') {
            $data->groupid = $to;
        }
        $data->save();

        foreach ($request->files as $file) {
            $filecontent = File::get($file);
            $originalfile = $file->getClientOriginalName();
            $filename = rand() . '_' . time() . '.' . $file->getClientOriginalExtension();
            Storage::disk('public')->put('messageimg/' . $filename, $filecontent);
            $img = new MessageImages();
            $img->image = $filename;
            $img->chat_id = $data->id;
            $img->save();
        }


        // pusher
        $options = array(
            'cluster' => 'ap2',
            'useTLS' => true
        );

        $pusher = new Pusher(
            env('PUSHER_APP_KEY'),
            env('PUSHER_APP_SECRET'),
            env('PUSHER_APP_ID'),
            $options
        );
        if ($request->type == 'group') {
            $data = ['from' => $from, 'to' => 'group_' . $to]; // sending from and to user id when pressed enter
        } else {
            $data = ['from' => $from, 'to' => $to]; // sending from and to user id when pressed enter
        }

        $pusher->trigger('my-channel', 'my-event', $data);
        $companyname = env("COMPANY_NAME");

        $title = "Message from $companyname";
        $flag = 'chat';
        $content = array('Title' => "Message from $companyname", 'Details' => $message, 'type' => $request->type, 'id' => $to);
        $notice = new NotificationController();
        if ($request->type == "individual") {
            $mo_user = DealerUser::where('id', $to)->first();
            $fcm_id = explode('::', $mo_user->fcm_id);
            $fcmid = implode('', $fcm_id);
            if ($fcmid) {
                // $notice->individualNotificationSend($fcmid, $title, $flag, $content);
            }
        }
        if ($request->type == "group") {
            // MessageGroup::where('id',$request->receiver_id)->first();
            $group_user = MessageGroupUser::where(['message_group_id' => $to, 'user_type' => 'user'])->pluck('user_id');
            $fcmid = DealerUser::where('fcm_id', '!=', null)->whereIn('id', $group_user)->pluck('fcm_id')->toArray();
            if (count($fcmid) > 0) {
                $notice->sendMessageMulti($title, $flag, $content, $fcmid);
            }
            // return $fcmid;

        }
    }

    public function search(Request $request)
    {
        $valid = Validator::make($request->all(), [
            'search' => 'max:91'
        ]);
        if ($valid->fails()) {
            return response()->json(['status' => 'error', 'message' => $valid->errors()], 422);
        }
        if (!$request->search) {
            $individual = [];
            $group = [];
            $user1 = Message::where([['from', '!=', 0], 'type' => 'individual'])->distinct()->pluck('from')->toArray();
            $user2 = Message::select('to')->where([['to', '!=', 0], 'type' => 'individual'])->distinct()->pluck('to')->toArray();
            $users = array_unique(array_merge($user1, $user2));
            $users = collect($users)->values();
            foreach ($users as $user) {
                $dealeruser = DealerUser::select('id', 'full_name')->where('id', $user)->first();
                $mess = Message::where(['type' => 'individual'])->where(function ($query) use ($user) {
                    $query->where('from', $user)->orWhere('to', $user);
                })
                    ->select('messages.id as message_id', 'message', 'is_read', 'created_at')->orderBy('created_at', 'DESC');
                $messagedata = $mess->first();
                $dealeruser->message = $messagedata;
                $dealeruser->unread = $mess->where([['from', '!=', 0], 'is_read' => 0])->count();
                $dealeruser->created_at = $messagedata->created_at;
                $dealeruser->type = 'individual';
                $individual[] = $dealeruser;
                $messagedata = '';
            }
            $messages = MessageGroup::whereHas('groupuser', function ($query) {
                $query->where(['message_group_users.user_id' => Auth::user()->id, 'user_type' => 'admin']);
            })->select('id', 'group_name as full_name')->where('status', 'Active')->get();
            foreach ($messages as $mes) {
                $mess = Message::where(['type' => 'group', 'groupid' => $mes->id])
                    ->select('messages.id as message_id', 'message', 'created_at')->orderBy('created_at', 'DESC');
                $groupmsg = $mess->first();
                $mes->unread = $mess->where([['from', '!=', 0], 'is_read' => 0])->count();
                $mes->created_at = $groupmsg ? $groupmsg->created_at : $mes->created_at;
                $mes->message = $groupmsg;
                $mes->type = 'group';
                $group[] = $mes;
                $groupmsg = '';
            }
            $list = collect(array_merge($individual, $group))->sortByDesc('created_at')->values();
            return view('dashboards.chat.users', ['users' => $list]);
        }
        $dealeruser = DealerUser::select('id', 'full_name', DB::raw("'individual' as type"), DB::raw("0 as unread"), DB::raw("null as created_at"), DB::raw("'' as message"))
            ->where('full_name', 'like', '%' . $request->search . '%')
            ->get()->toArray();
        $messages = MessageGroup::whereHas('groupuser', function ($query) {
            $query->where(['message_group_users.user_id' => Auth::user()->id, 'user_type' => 'admin']);
        })->select('id', 'group_name as full_name', DB::raw("'group' as type"), DB::raw("0 as unread"), DB::raw("null as created_at"), DB::raw("'' as message"))
            ->where(['status' => 'Active', ['group_name', 'like', '%' . $request->search . '%']])
            ->get()->toArray();

        $user = json_decode(collect(array_merge($dealeruser, $messages)));
        // return$user[0]->id);
        return view('dashboards.chat.users', ['users' => $user]);
    }
}
