<?php

namespace App\Http\Controllers;

use App\MessageGroup;
use App\MessageGroupUser;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Session;
use App\User;
use App\DealerUser;
use Illuminate\Support\Facades\Auth;
use Carbon\Carbon;

class MessageGroupController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $group = MessageGroup::all();

        return view('dashboards.chat-group.index', ['groups' => $group]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $users =  DealerUser::all();
        $admin = User::all();
        return view('dashboards/chat-group/create', ['admins' => $admin, 'users' => $users]);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->validate($request, [
            'group_name' => "required|string|max:255|unique:message_groups,group_name",
            'status' => 'required|in:Inactive,Active',
            'mo_user' => 'nullable|array',
            'admin_user' => 'nullable|array',
            'mo_user.*' => 'exists:dealer_user_info,id',
            'admin_user.*' => 'exists:users,id'
        ]);
        $groupadmin = [];
        $groupuser = [];
        $group = new MessageGroup();

        $group->group_name = $request->group_name;
        $group->status = $request->status;
        $group->created_by = Auth::user()->id;
        if ($group->save()) {
            if($request->mo_user){
            if (count($request->mo_user) > 0) {
                foreach ($request->mo_user as $user) {
                    $groupuser[] = array(
                        'user_id' => $user,
                        'admin_user' => null,
                        'user_type' => 'user',
                        'status' => 'added',
                        'message_group_id' => $group->id,
                        'created_at' => (string)Carbon::now(),
                        'updated_at' => (string)Carbon::now()
                    );
                }
            }
        }
            if ($request->admin_user&&(count($request->admin_user)>0)) {
                foreach ($request->admin_user as $admin) {
                    $groupadmin[] = array(
                        'user_id' => $admin,
                        'admin_user' => $admin,
                        'user_type' => 'admin',
                        'status' => 'added',
                        'message_group_id' => $group->id,
                        'created_at' => (string)Carbon::now(),
                        'updated_at' => (string)Carbon::now()
                    );
                }
            } else {
                $groupadmin[] = array(
                    'user_id' => Auth::user()->id,
                    'admin_user' => Auth::user()->id,
                    'user_type' => 'admin',
                    'status' => 'added',
                    'message_group_id' => $group->id,
                    'created_at' => (string)Carbon::now(),
                    'updated_at' => (string)Carbon::now()
                );
            }
            $data = array_merge($groupadmin, $groupuser);
            // return $data;
            if (count($data) > 0) {
                MessageGroupUser::insert($data);
            }
            Session::flash('Status', 'Group Created Successfully');
            return redirect('/dashboard/chat-group');
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\MessageGroup  $messageGroup
     * @return \Illuminate\Http\Response
     */
    public function show(MessageGroup $messageGroup,$id)
    {
        $group = MessageGroup::with('groupuser')->findorFail($id);
        foreach($group->groupuser as $user){
            if($user->user_type=='admin'){
                $username = User::select('name as username')->where('id',$user->user_id)->first();
            }else{
                $username = DealerUser::select('full_name as username')->where('id',$user->user_id)->first();
            }
            $user->username = $username->username;
        }
        return view('dashboards.chat-group.show',['group'=>$group]);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\MessageGroup  $messageGroup
     * @return \Illuminate\Http\Response
     */
    public function edit(MessageGroup $messageGroup, $id)
    {
        $data['users'] = DealerUser::where('status', 1)->get();
        $data['admins'] = User::all();
        $data['messageGroup'] = MessageGroup::with(['groupuser'=>function($query){
                $query->where(['status'=>'added']);
        }])->findorFail($id);

        return view('dashboards.chat-group.edit', $data);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\MessageGroup  $messageGroup
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, MessageGroup $messageGroup, $id)
    {
        $this->validate($request, [
            'group_name' => "required|string|max:255",
            'status' => 'required|in:Inactive,Active',
            'mo_user' => 'array',
            'admin_user' => 'array',
            'mo_user.*' => 'exists:dealer_user_info,id',
            'admin_user.*' => 'exists:users,id'
        ]);

        $message = MessageGroup::findorFail($id);
        if($message->group_name != $request->group_name){
            $this->validate($request, [
            'group_name' => "required|string|max:255|unique:message_groups,group_name"
        ]);
        }
        $message->group_name = $request->group_name;
        $message->status = $request->status;

        $message->save();
        if($request->mo_user){
        if (count($request->mo_user) > 0) {
            foreach ($request->mo_user as $user) {
                $group_user = MessageGroupUser::where(['message_group_id'=>$message->id,'user_id' => $user, 'user_type' => 'user'])->first();
                if ($group_user) {
                    if ($group_user->status == 'removed') {
                        $group_user->status = 'added';
                        $group_user->save();
                    }
                    // $group_user->user_id = 
                } else {
                    $userGroup = new MessageGroupUser();
                    $userGroup->user_id = $user;
                    $userGroup->user_type = 'user';
                    $userGroup->status = 'added';
                    $userGroup->message_group_id = $message->id;

                    $userGroup->save();
                }
            }
        }
        $removeusers = MessageGroupUser::whereNotIn('user_id',$request->mo_user)->where(['message_group_id'=>$message->id, 'user_type' => 'user'])->get();

        foreach ($removeusers as $rmuser) {
            $rmuser->status = 'removed';

            $rmuser->save();
        }
    }else{
        MessageGroupUser::where(['message_group_id'=>$message->id,'status'=>'added','user_type'=>'user'])->update(['status' => 'removed']);
    }
    if($request->admin_user){
        if (count($request->admin_user) > 0) {
            foreach ($request->admin_user as $adminuser) {
                $group_user = MessageGroupUser::where(['message_group_id'=>$message->id,'user_id' => $adminuser, 'user_type' => 'admin'])->first();
                if ($group_user) {
                    if ($group_user->status == 'removed') {
                        $group_user->status = 'added';
                        $group_user->save();
                    }
                    // $group_user->user_id = 
                } else {
                    $userGroup = new MessageGroupUser();
                    $userGroup->user_id = $adminuser;
                    $userGroup->user_type = 'admin';
                    $userGroup->status = 'added';
                    $userGroup->message_group_id = $message->id;

                    $userGroup->save();
                }
            }
        }
        $removeadminusers = MessageGroupUser::whereNotIn('user_id',$request->admin_user)->where(['message_group_id'=>$message->id, 'user_type' => 'admin'])->get();

        foreach ($removeadminusers as $rmadminuser) {
            $rmadminuser->status = 'removed';

            $rmadminuser->save();
        }
    }else{
        MessageGroupUser::where(['message_group_id'=>$message->id,'status'=>'added','user_type'=>'admin'])->update(['status' => 'removed']);
    }
        Session::flash('Status','Chat Group Updated');
        return redirect('/dashboard/chat-group');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\MessageGroup  $messageGroup
     * @return \Illuminate\Http\Response
     */
    public function destroy(MessageGroup $messageGroup,$id)
    {
        $message = MessageGroup::findorFail($id);
        if ($message->status=='Active') {
            $message->status = 'Inactive';

            $message->save();
            Session::flash('Status', 'Group Inactivated !!!');
        }else{
            $message->status = 'Active';

            $message->save();
            Session::flash('Status', 'Group Activated !!!');
        }
        // Session::flash('Status', 'Sorry cannot be delete this group');
        return back();
    }
}
