<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Notice;
use App\DealerUser;
use App\DealerInfo;
// use App\Traits\Nepali_Calendar;
use App\Http\Controllers\NotificationController;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Auth;

class NoticeController extends Controller
{

    // use Nepali_Calendar; notices
    public function index()
    {
        $today = date('Y-m-d');

        $not = Notice::orderBy('date', 'ASC')->get();
        foreach ($not as $n) {

            if (!empty($n->user_id)) {
                $name = DealerInfo::select('firm_name')->where('id', $n->user_id)->first();
                $user = $name->firm_name;
            } else {
                $user = '';
            }
            $list[] = array(
                'id' => $n->id,
                'title' => $n->title,
                'notice' => $n->notice,
                'expiry_date' => $n->expiry_date,
                'user_id' => $n->user_id,
                'publish' => $n->publish,
                'user' => $user,
                'today' => $today,
            );
        }

        $users = DealerInfo::get();
        if (!empty($list)) {
            return view('dashboards.notices.show', ['notices' => $list, 'users' => $users, 'mr' => '', 'from' => '', 'start' => 'index']);
        } else {
            return view('dashboards.notices.show', ['notices' => '', 'users' => $users, 'mr' => '', 'from' => '', 'start' => 'index']);
        }

        $users = DealerInfo::get();
        $notices = DB::table('notices')
            ->join('dealer_info', 'notices.user_id', 'dealer_info.id')
            ->get();
        return view('dashboards.notices.show', ['notices' => $notices, 'users' => $users]);
    }

    public function noticeView()
    {
        $users = DealerInfo::get();
        return view('dashboards.notices.create', ['users' => $users]);
    }

    public function store(Request $request)
    {
        $date = Date('Y-m-d');
        $this->validate($request, [
            'user' => 'nullable|exists:dealer_info,id',
            'expiry_date' => 'date_format:Y-m-d|after_or_equal:' . $date,
            'title' => 'required|string|max:255',
            'notice' => 'required'
        ]);

        $dates =  $request->expiry_date;

        $notice = new Notice();

        $notice->user_id = $request->user;
        $notice->title =  $request->title;
        $notice->notice = $request->notice;
        $notice->date = date('Y-m-d');
        $notice->expiry_date = $dates;
        $notice->publish = '0';
        $notice->created_by = Auth::user()->id;

        $notice->save();
        return redirect('/dashboard/notice')->with('Status', 'New Notice Created.');
    }
    public function readmore($id)
    {
        $notice = Notice::findorFail($id);
        return view('dashboards.notices.popup', ['noti' => $notice]);
    }
    public function editView($id)
    {
        $notice = Notice::findorFail($id);

        $expd = $notice->expiry_date;

        $list[] = array(
            'id' => $notice->id,
            'title' => $notice->title,
            'notice' => $notice->notice,
            'expiry_date' => $expd,
            'user_id' => $notice->user_id,
        );
        // return $list;
        $mobile = DealerInfo::all();
        return view('dashboards.notices.edit', ['notice' => $list, 'users' => $mobile]);
    }
    public function update($id, Request $request)
    {
        $date = Date('Y-m-d');
        $this->validate($request, [
            'user' => 'nullable|exists:dealer_info,id',
            'expiry_date' => 'date_format:Y-m-d|after_or_equal:' . $date,
            'title' => 'required|string|max:255',
            'notice' => 'required'
        ]);

        $today = Date('Y-m-d');
        if ($request['expiry_date'] < $today) {

            return redirect('dashboard/notice/' . $id . '/edit')->with('status', 'The expiry-date must be a date after or equal to today');
        }

        $dates = $request->expiry_date;

        $notice = Notice::findorFail($id);
        $notice->title = $request->title;
        $notice->notice = $request->notice;
        $notice->expiry_date = $dates;
        $notice->user_id = $request->user;
        $notice->save();
        return redirect('dashboard/notice')->with('Status', 'Notice Edited.');
    }

    public function search(Request $request)
    {
        $this->validate($request, [
            'date' => 'nullable|date_format:Y-m-d|after_or_equal:today',
            'user' => 'nullable|exists:dealer_info,id'
        ]);
        $today = Date('Y-m-d');
        if ($request['date'] > $today) {
            return redirect('dashboard/notice')->with('status', 'The start-date must be a date before or equal to today');
        }
        $id = $request->user;
        $date_req = $request->date;
        $dates = $request->date;
        if (empty($date_req) && empty($id)) {
            $notices = Notice::orderBy('created_at', 'desc')->get();
            foreach ($notices as $n) {
                if (!empty($n->user_id)) {
                    $name = DealerInfo::select('firm_name')->where('id', $n->user_id)->first();
                    $user = $name->firm_name;
                } else {
                    $user = '';
                }
                $expd = $n->expiry_date;
                $list[] = array(
                    'id' => $n->id,
                    'title' => $n->title,
                    'notice' => $n->notice,
                    'expiry_date' => $expd,
                    'today' => $today,
                    'user_id' => $n->user_id,
                    'publish' => $n->publish,
                    'user' => $user,
                );
            }

            $users = DealerInfo::get();
            if (!empty($list)) {
                return view('dashboards.notices.show', ['notices' => $list, 'users' => $users, 'from' => '', 'mr' => '', 'start' => '', 'dealerid' => $request->user]);
            } else {
                return view('dashboards.notices.show', ['notices' => '', 'users' => $users, 'from' => '', 'mr' => '', 'start' => '', 'dealerid' => $request->user]);
            }
        } elseif (empty($id) && !empty($date_req)) {
            $notices = Notice::where('date', $dates)->orderBy('created_at', 'desc')->get();
            foreach ($notices as $n) {
                $expd = $nepaliYr . '-' . $nepaliMth . '-' . $nepaliDay;

                $expd = $n->expiry_date;

                if (!empty($n->user_id)) {
                    $name = DealerInfo::select('firm_name')->where('id', $n->user_id)->first();
                    $user = $name->firm_name;
                } else {
                    $user = '';
                }

                $list[] = array(
                    'id' => $n->id,
                    'title' => $n->title,
                    'notice' => $n->notice,
                    'expiry_date' => $expd,
                    'today' => $today,
                    'user_id' => $n->user_id,
                    'publish' => $n->publish,
                    'user' => $user,
                );
            }
            $users = DealerInfo::get();
            if (!empty($list)) {
                return view('dashboards.notices.show', ['notices' => $list, 'users' => $users, 'from' => $date_req, 'mr' => '', 'start' => '', 'dealerid' => $request->user]);
            } else {
                return view('dashboards.notices.show', ['notices' => '', 'users' => $users, 'from' => $date_req, 'mr' => '', 'start' => '', 'dealerid' => $request->user]);
            }
        } elseif (!empty($id) && empty($date_req)) {
            $notices = Notice::where('user_id', $id)->orwhere('user_id', null)->orderBy('created_at', 'DESC')->get();

            foreach ($notices as $n) {
                $expd = $n->expiry_date;
                if (!empty($n->user_id)) {
                    $userid = explode('::', $n->user_id);
                    $user_id = implode('', $userid);
                    $name = DealerInfo::select('firm_name')->where('id', $user_id)->first();
                    $user = $name->firm_name;
                } else {
                    $user = '';
                }
                $list[] = array(
                    'id' => $n->id,
                    'title' => $n->title,
                    'notice' => $n->notice,
                    'expiry_date' => $expd,
                    'today' => $today,
                    'user_id' => $n->user_id,
                    'publish' => $n->publish,
                    'user' => $user,
                );
            }
            $users = DealerInfo::get();
            $officer = DealerInfo::where('id', $id)->first();
            $mr = $officer->firm_name;

            if (!empty($list)) {
                return view('dashboards.notices.show', ['notices' => $list, 'users' => $users, 'from' => '', 'mr' => $mr, 'start' => '', 'dealerid' => $request->user]);
            } else {
                return view('dashboards.notices.show', ['notices' => '', 'users' => $users, 'from' => '', 'mr' => $mr, 'start' => '', 'dealerid' => $request->user]);
            }
        } else {
            // return $date_req;
            $notices = Notice::where('user_id', $id)->where('date', $dates)->orWhere('user_id', null)->where('date', $dates)->orderBy('date', 'DESC')->get();
            // return $notices;
            foreach ($notices as $n) {
                $expd = $n->expiry_date;
                if (!empty($n->user_id)) {
                    $userid = explode('::', $n->user_id);
                    $user_id = implode('', $userid);
                    $name = DealerInfo::select('firm_name')->where('id', $user_id)->first();
                    // $username = explode('::',$name->full_name);
                    $user = $name->firm_name;
                } else {
                    $user = '';
                }
                $list[] = array(
                    'id' => $n->id,
                    'title' => $n->title,
                    'notice' => $n->notice,
                    'expiry_date' => $expd,
                    'today' => $today,
                    'user_id' => $n->user_id,
                    'publish' => $n->publish,
                    'user' => $user,
                );
            }
            $users = DealerInfo::get();
            $officer = DealerInfo::where('id', $id)->first();
            $mr = $officer->firm_name;
            if (!empty($list)) {
                return view('dashboards.notices.show', ['notices' => $list, 'users' => $users, 'from' => $date_req, 'mr' => $mr, 'start' => '', 'dealerid' => $request->user]);
            } else {
                return view('dashboards.notices.show', ['notices' => '', 'users' => $users, 'from' => $date_req, 'mr' => $mr, 'start' => '', 'dealerid' => $request->user]);
            }
        }
    }

    public function noticePush($id)
    {
        $notice = Notice::findorFail($id);

        $notice->publish = '1';
        $notice->save();

        return redirect('dashboard/notice')->with('Status', 'Notice has been published.');
    }
    public function delete($id)
    {
        Notice::findorFail($id)->delete();
        return back()->with("Status", "Notice Deleted.");
    }
}
