<?php

namespace App\Http\Controllers;

use App\User;
use App\Order;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Auth;
use App\LogDetail;
use App\Orderitem;
use App\DealerUser;
use App\DealerInfo;
use App\ProductSize;
use App\Size;
// use App\Traits\FCM;
// use App\Traits\Nepali_Calendar;
use App\Noticelog;

class OrderController extends Controller
{
    // use FCM;
    // use Nepali_Calendar;
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */

    public function general()
    {
        $dealers = DealerInfo::all();
        // return $dealers;

        $order = DB::table('orders')
            ->join('dealer_info', 'orders.dealer_code', 'dealer_info.id')
            ->join('dealer_user_info', 'orders.user_id', 'dealer_user_info.id')
            ->select('orders.id as order_id', 'dealer_info.firm_name as dealer_name', 'orders.date as order_date', 'orders.status as order_status', 'dealer_user_info.full_name as user_name', 'orders.remarks')
            ->where('orders.status', 'pending')
            ->get();

        if (empty($order)) {
            return view('dashboards.orders.show', ['dealers' => $dealers, 'order' => '', 'from' => '', 'to' => '', 'de' => '', 'start' => 'index']);
        } else {
            return view('dashboards.orders.show', ['order' => $order, 'dealers' => $dealers, 'from' => '', 'to' => '', 'de' => '', 'start' => 'index']);
        }
    }

    public function index($id)
    {
        $o = Order::findorFail($id);
        $order = DB::table('orders')
            ->join('orderitems', 'orderitems.order_id', '=', 'orders.id')
            ->join('product_size', 'product_size.id', '=', 'orderitems.items_id')
            ->join('products', 'products.id', '=', 'product_size.product_id')
            ->join('sizes', 'sizes.id', '=', 'product_size.size_id')
            ->join('dealer_info', 'dealer_info.id', '=', 'orders.dealer_code')
            ->join('dealer_user_info', 'dealer_user_info.id', '=', 'orders.user_id')
            ->join('categories', 'categories.id', '=', 'products.category_id')
            ->select('orders.id as order_id', 'orderitems.quantity as quantity', 'orderitems.discount_amount as discount', 'orderitems.price', 'orderitems.status', 'orderitems.id as orderitems_id', 'products.name as product_name', 'sizes.size as size', 'dealer_info.firm_name as dealer_name', 'orders.date as order_date', 'orders.status as order_status', 'dealer_user_info.full_name as user_name', 'categories.name as category_name', 'orders.remarks')
            ->where('orders.id', $id)
            ->get();

        $dealerName = '';
        $mo = '';
        foreach ($order as $n) {
            $dealerName = $n->dealer_name;
            $mo = $n->user_name;
        }

        if (empty($order)) {
            return view('dashboards.orders.list', ['order' => '', 'dealer' => '', 'mo' => '', 'o' => '']);
        } else {
            return view('dashboards.orders.list', ['order' => $order, 'dealer' => $dealerName, 'mo' => $mo, 'o' => $o->id]);
        }
    }

    public function range(Request $request)
    {
        $today = date('Y-m-d');
        $this->validate($request, [
            'dealer' => 'nullable|exists:dealer_info,id',
            'end-date' => 'required|date_format:Y-m-d|after_or_equal:start-date',
            'start-date' => 'required|required_with_all:end-date|date|date_format:Y-m-d|before_or_equal:' . $today,
            'order_status' => 'nullable|in:pending,ongoing,completed,cancelled'
        ]);
        if ($request['start-date'] > $today) {

            return redirect('dashboard/order')->with('status', 'The start-date must be a date before or equal to today');
        }


        $dealers = DealerInfo::get();
        $dealer = $request->dealer;
        $fr = $request['start-date'];
        $t = $request['end-date'];


        if (!empty($request['start-date'])) {
            $from = $request['start-date'];
        }
        if (!empty($request['end-date'])) {

            $to = $request['end-date'];
        }
        $date = date('Y-m-d');
        if ($request->dealer && $request->order_status) {
            $order = DB::table('orders')
                ->join('dealer_info', 'dealer_info.id', '=', 'orders.dealer_code')
                ->join('dealer_user_info', 'dealer_user_info.id', '=', 'orders.user_id')
                ->select('orders.id as order_id', 'dealer_info.firm_name as dealer_name', 'orders.date as order_date', 'orders.status as order_status', 'dealer_user_info.full_name as user_name', 'orders.remarks')
                ->where(['orders.dealer_code' => $dealer, 'orders.status' => $request->order_status])
                ->whereBetween('date', [$from, $to])
                // ->take(1)
                ->orderBy('orders.id', 'DESC')
                ->get();
        } elseif (!$request->dealer && $request->order_status) {
            $order = DB::table('orders')
                ->join('dealer_info', 'dealer_info.id', '=', 'orders.dealer_code')
                ->join('dealer_user_info', 'dealer_user_info.id', '=', 'orders.user_id')
                ->select('orders.id as order_id', 'dealer_info.firm_name as dealer_name', 'orders.date as order_date', 'orders.status as order_status', 'dealer_user_info.full_name as user_name', 'orders.remarks')
                ->where('orders.status', $request->order_status)
                ->whereBetween('date', [$from, $to])
                ->get();
        } elseif ($request->dealer && !$request->order_status) {
            $order = DB::table('orders')
                ->join('dealer_info', 'dealer_info.id', '=', 'orders.dealer_code')
                ->join('dealer_user_info', 'dealer_user_info.id', '=', 'orders.user_id')
                ->select('orders.id as order_id', 'dealer_info.firm_name as dealer_name', 'orders.date as order_date', 'orders.status as order_status', 'dealer_user_info.full_name as user_name', 'orders.remarks')
                ->where(['orders.dealer_code' => $dealer])
                ->whereBetween('date', [$from, $to])
                // ->take(1)
                ->orderBy('orders.id', 'DESC')
                ->get();
        } else {
            $order = DB::table('orders')
                ->join('dealer_info', 'dealer_info.id', '=', 'orders.dealer_code')
                ->join('dealer_user_info', 'dealer_user_info.id', '=', 'orders.user_id')
                ->select('orders.id as order_id', 'dealer_info.firm_name as dealer_name', 'orders.date as order_date', 'orders.status as order_status', 'dealer_user_info.full_name as user_name', 'orders.remarks')
                ->whereBetween('date', [$from, $to])
                ->get();
        }

        if (!empty($dealer)) {
            $dea = DealerInfo::where('id', $dealer)->first();
            $d = $dea->firm_name;
            $dealer_id = $dea->id;
            $obj = new \stdClass();
            $obj->order_id = "Summary";
            $obj->dealer_name = $d;
            $obj->order_status = "n-a";
            $obj->order_date = "n-a";
            $obj->remarks = "n-a";
            $obj->user_name = 'n-a';
            $obj1[] = $obj;
            $order = array_merge($obj1, $order->toArray());
        } else {
            $d = '';
            $dealer_id = '';
        }
        if ($request->order_status) {
            $status = $request->order_status;
        } else {
            $status = 'All';
        }
        if (empty($order)) {
            return view('dashboards.orders.search', ['dealers' => $dealers, 'order' => '', 'from' => $fr, 'to' => $t, 'de' => $d, 'start' => '', 'status' => $status, 'dealer_id' => $dealer_id]);
        } else {
            return view('dashboards.orders.search', ['dealers' => $dealers, 'order' => $order, 'from' => $fr, 'to' => $t, 'de' => $d, 'start' => '', 'status' => $status, 'dealer_id' => $dealer_id]);
        }
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update($id)
    {
        $date = date('Y-m-d');
        $orders = Order::findorFail($id);

        $orders->status = request('status');
        $orders->remarks = request('remark');
        $price = 0;
        $items = Orderitem::where('order_id', $orders->id)->get();
        foreach ($items as $item) {
            $p = ProductSize::findorFail($item->items_id);
            $price = $price + ($item->quantity * $p->price);
        }
        $due = DealerInfo::findorFail($orders->dealer_code);
        $toalAmt = $due->due_amount + $price;
        if (request('status') == 'completed') {

            if ($due->order_limit < $toalAmt) {
                return back()->with('error', 'Dealer Order Limit Exceeded. Current Due Amount is Rs.' . $due->due_amount . ' and Order Amount is Rs.' . $price . '. Total Amount Rs.' . $toalAmt . ' exceeds the limit of Rs.' . $due->order_limit . '. Kindly adjust the order accordingly.');
            }
        } elseif (request('status') == 'cancelled') {
            $due->due_amount -= $price;
            $due->save();
        }
        $orders->save();

        $dealer = DealerInfo::where('id', $orders->dealer_code)->first();
        $del = explode('::', $dealer->name);
        $dealer_name = implode('', $del);

        if (!empty($otp = DealerUser::where(['id' => $orders->user_id])->first())) {
            $fcmid = $otp->fcm_id;
            $flag = "order";
            $title = "Sales Tracker";
            $detail = $orders->id;
            $mess = request('remark');
            if (empty($mess)) {
                $mess = 'Order Status Updated';
            }
            Noticelog::create([
                'user_id' => $orders->user_id,
                'flag' => 'order',
                'title' => 'Order Status Update',
                'notice' => 'Order has been updated.',
                'date' => date('Y-m-d'),
            ]);

            $content = array('Title' => 'Order Status Updated', 'Details' => $mess);
            if (!empty($fcmid)) {
                $notice = new NotificationController();
                // $notice->individualNotificationSend($fcmid, $title, $flag, $content);
            }
        }

        $dealers = DealerInfo::get();

        $order = DB::table('orders')
            ->join('dealer_info', 'dealer_info.id', '=', 'orders.dealer_code')
            ->join('dealer_user_info', 'dealer_user_info.id', '=', 'orders.user_id')
            ->select('orders.id as order_id', 'dealer_info.firm_name as dealer_name', 'orders.date as order_date', 'orders.status as order_status', 'dealer_user_info.full_name as user_name', 'orders.remarks')
            ->where('orders.status', '=', 'pending')
            ->get();

        $log = new LogDetail();
        $log->flag = 'order';
        $log->order_id = $orders->id;
        $log->cheque_no = $orders->cheque_num;
        $log->date = $date;
        $log->admin = Auth::user()->id;
        $log->user_id = $orders->user_id;
        $log->status = request('status');
        $log->remarks = request('remark');
        $log->previous_status = request('previous_status');

        return back()->with('Status', 'Order Status Changed.');
    }

    public function status($status)
    {
        $dealers = DealerInfo::get();

        $order = DB::table('orders')
            ->join('dealer_info', 'orders.dealer_code', 'dealer_info.id')
            ->join('dealer_user_info', 'orders.user_id', 'dealer_user_info.id')
            ->select('orders.id as order_id', 'dealer_info.firm_name as dealer_name', 'orders.date as order_date', 'orders.status as order_status', 'dealer_user_info.full_name as user_name', 'orders.remarks')
            ->where('orders.status', $status)
            ->get();

        if (empty($order)) {
            return view('dashboards.orders.show', [
                'dealers' => $dealers,
                'order' =>
                '',
                'from' => '',
                'to' => '',
                'de' => '',
                'start' => 'index'
            ]);
        } else {
            return view('dashboards.orders.show', [
                'order' => $order,
                'dealers' => $dealers,
                'from' => '',
                'to' => '',
                'de' => '',
                'start' => 'index'
            ]);
        }
    }

    public function pop($id)
    {
        $log = LogDetail::where('order_id', $id)->where('flag', 'order')->get();

        foreach ($log as $n) {
            $date = $n->date;

            $user =  User::findorFail($n->admin);

            $list[] = array(
                'ordercoll_id' => $n->order_id,
                'status' => $n->status,
                'previous_status' => $n->previous_status,
                'admin' => $user->name,
                'remarks' => $n->remarks,
                'date' => $date,
            );
        }
        if (!empty($list)) {
            return view('dashboards.orders.log', ['log' => $list]);
        } else {
            return view('dashboards.orders.log');
        }
    }


    public function allOrder($id)
    {
        // return Order::findorFail(6);
        $o = Order::findorFail($id);
        $user = $o->user_id;
        $dealer = $o->dealer_code;

        $order = DB::table('orders')
            ->join('orderitems', 'orderitems.order_id', '=', 'orders.id')
            ->join('product_size', 'product_size.id', '=', 'orderitems.items_id')
            ->join('products', 'products.id', '=', 'product_size.product_id')
            ->join('sizes', 'sizes.id', '=', 'product_size.size_id')
            ->join('dealer_info', 'dealer_info.id', '=', 'orders.dealer_code')
            ->join('dealer_user_info', 'dealer_user_info.id', '=', 'orders.user_id')
            ->join('categories', 'categories.id', '=', 'products.category_id')
            ->select('orders.id as order_id', 'orderitems.id as orderitems_id', 'orderitems.quantity as quantity', 'orderitems.discount_amount as discount', 'orderitems.price', 'orderitems.items_price_rate as rate', 'orderitems.status', 'orderitems.id as sizeid', 'products.name as product_name', 'sizes.size as size', 'dealer_info.firm_name as dealer_name', 'orders.date as order_date', 'orders.status as order_status', 'dealer_user_info.full_name as user_name', 'categories.name as category_name', 'orders.remarks')
            ->where('orders.dealer_code', $dealer)
            ->where('orders.user_id', $user)
            ->where('orders.status', $o->status)
            //    ->where('orderitems.status','0')
            ->get();
        //    return $order;

        foreach ($order as $n) {
            $order_date = $n->order_date;

            $dName = $n->dealer_name;
            $mo = $n->user_name;

            $list[] = array(
                'order_id' => $n->order_id,
                'dealer_name' => $n->dealer_name,
                'order_status' => $n->order_status,
                'quantity' => $n->quantity,
                'price' => $n->price,
                'product_name' => $n->product_name,
                'size' => $n->size,
                'category_name' => $n->category_name,
                'order_date' => $order_date,
                'remarks' => $n->remarks,
                'user_name' => $n->user_name,
                'sizeid' => $n->sizeid,
                'status' => $n->status,
                'price' => $n->price,
                'discount' => $n->discount,
                'orderitems_id' => $n->orderitems_id
            );
        }
        //    return $list;
        if (empty($list)) {
            return view('dashboards.orders.allOrderList', ['order' => '', 'dealer' => '', 'mo' => '', 'o' => '']);
        } else {
            return view('dashboards.orders.allOrderList', ['order' => $list, 'dealer' => $dName, 'mo' => $mo, 'o' => $o]);
        }
    }
    function editOrderView($id)
    {
        // DB::select("select * from ")
        $products = DB::table('products')
            ->join('product_size', 'products.id', 'product_size.product_id')
            ->distinct('product_size.product_id')
            ->select('products.id', 'products.name')
            ->get();
        // return $products;
        $orderItems = Orderitem::findorFail($id);
        $item_id = $orderItems->items_id;
        $size = ProductSize::where('id', $item_id)->first();
        $product_size = ProductSize::where('product_id', $size->product_id)->get();
        $variants = Size::all();
        return view('dashboards.orders.orderEdit', ['products' => $products, 'orderItems' => $orderItems, 'variants' => $variants, 'size' => $size]);
    }
}
// Ledger Controller
