<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\User;
use App\Order;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Auth;
use App\LogDetail;
use App\Orderitem;
use App\DealerUser;
use App\DealerInfo;
use App\ProductSize;
use App\Size;
// use App\Traits\FCM;
// use App\Traits\Nepali_Calendar;
use App\Noticelog;

class OrderFilterController extends Controller
{
    public function filter(Request $request){
        if($request->status!='All'){
        $order = DB::table('orders')
            ->join('orderitems', 'orderitems.order_id', '=', 'orders.id')
            ->join('product_size', 'product_size.id', '=', 'orderitems.items_id')
            ->join('products', 'products.id', '=', 'product_size.product_id')
            ->join('sizes', 'sizes.id', '=', 'product_size.size_id')
            ->join('dealer_info', 'dealer_info.id', '=', 'orders.dealer_code')
            ->join('dealer_user_info', 'dealer_user_info.id', '=', 'orders.user_id')
            ->join('categories', 'categories.id', '=', 'products.category_id')
            ->select('orders.id as order_id', 'orderitems.quantity as quantity','orderitems.discount_amount as discount','orderitems.price','orderitems.items_price_rate as rate', 'orderitems.status', 'orderitems.id as orderitems_id','orderitems.items_id', 'products.name as product_name', 'sizes.size as size', 'dealer_info.firm_name as dealer_name', 'orders.date as order_date', 'orders.status as order_status', 'dealer_user_info.full_name as user_name', 'categories.name as category_name', 'orders.remarks')
            ->where(['orders.dealer_code'=>$request->dealer_id,'orders.status'=>$request->status])
            ->whereBetween('orders.date',[$request->from,$request->to])
            ->get();
        }else{
            $order = DB::table('orders')
            ->join('orderitems', 'orderitems.order_id', '=', 'orders.id')
            ->join('product_size', 'product_size.id', '=', 'orderitems.items_id')
            ->join('products', 'products.id', '=', 'product_size.product_id')
            ->join('sizes', 'sizes.id', '=', 'product_size.size_id')
            ->join('dealer_info', 'dealer_info.id', '=', 'orders.dealer_code')
            ->join('dealer_user_info', 'dealer_user_info.id', '=', 'orders.user_id')
            ->join('categories', 'categories.id', '=', 'products.category_id')
            ->select('orders.id as order_id', 'orderitems.quantity as quantity', 'orderitems.status', 'orderitems.id as orderitems_id','orderitems.discount_amount as discount','orderitems.price','orderitems.items_price_rate as rate','orderitems.items_id', 'product_size.price as price', 'products.name as product_name', 'sizes.size as size', 'dealer_info.firm_name as dealer_name', 'orders.date as order_date', 'orders.status as order_status', 'dealer_user_info.full_name as user_name', 'categories.name as category_name', 'orders.remarks')
            ->where(['orders.dealer_code'=>$request->dealer_id])
            ->whereBetween('orders.date',[$request->from,$request->to])
            ->get();
        }
        if($request->dealer_id){
            $collection = collect($order);
            $order = $collection->unique('items_id');
            foreach($order as $uniqueordr){
                $uniqueordr->quanity = $order->where('items_id',$uniqueordr->items_id)->sum('quantity');
            }
            foreach ($order as $n) {

                $order_date = $n->order_date;
    
                $dealer = $n->dealer_name;
                $mo = $n->user_name;
                $list[] = array(
                    'order_id' => $n->order_id,
                    'dealer_name' => $n->dealer_name,
                    // 'order_status' => $n->order_status,
                    'quantity' => $n->quantity,
                    'price' => $n->price,
                    'orderitems_id' => $n->orderitems_id,
                    'product_name' => $n->product_name,
                    'size' => $n->size,
                    'category_name' => $n->category_name,
                    'order_date' => "n-a",
                    'remarks' => $n->remarks,
                    // 'status' => $n->status,
                    'user_name' => $n->user_name,
                    'discount'=>$n->discount,
                    'orderitems_id'=>$n->orderitems_id
                );
            }
        }else{
        foreach ($order as $n) {

            $order_date = $n->order_date;

            $dealer = $n->dealer_name;
            $mo = $n->user_name;

            $list[] = array(
                'order_id' => $n->order_id,
                'dealer_name' => $n->dealer_name,
                'order_status' => $n->order_status,
                'quantity' => $n->quantity,
                'price' => $n->price,
                'orderitems_id' => $n->orderitems_id,
                'product_name' => $n->product_name,
                'size' => $n->size,
                'category_name' => $n->category_name,
                'order_date' => $order_date,
                'remarks' => $n->remarks,
                'status' => $n->status,
                'user_name' => $n->user_name,
                'discount'=>$n->discount,
                'orderitems_id'=>$n->orderitems_id
            );
        }
    }
        // return $list;
        if (empty($list)) {
            return view('dashboards.orders.list', ['order' => '', 'dealer' => '', 'mo' => '', 'o' => '']);
        } else {
            return view('dashboards.orders.list', ['order' => $list, 'dealer' => $dealer, 'mo' => $mo]);
        }
    }
    public function pop($id,$status){
        $order_info = Order::where('id',$id)->first();
        if($status!='All'){
            $orderid = Order::where('dealer_code',$order_info->dealer_code)->pluck('id');
            $log = LogDetail::whereIn('order_id', $orderid)->where('flag', 'order')->get();
        }else{
            $orderid = Order::where(['dealer_code'=>$order_info->dealer_code,'status'=>$order_info->status])->pluck('id');
            $log = LogDetail::whereIn('order_id', $orderid)->where('flag', 'order')->get();
        }
        
        foreach ($log as $n) {
            $date = $n->date;

            $user =  User::findorFail($n->admin);

            $list[] = array(
                'ordercoll_id' => $n->order_id,
                'status' => $n->status,
                'previous_status' => $n->previous_status,
                'admin' => $user->name,
                'remarks' => $n->remarks,
                'date' => $date,
            );
        }
        if (!empty($list)) {
            return view('dashboards.orders.log', ['log' => $list]);
        } else {
            return view('dashboards.orders.log');
        }
    }
}
