<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\DealerInfo;
use App\DealerUser;
use App\Scheme;
use App\Noticelog;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\File;
// use App\Traits\Nepali_Calendar;

class OtherController extends Controller
{
    // use Nepali_Calendar;

    public function ledgerView()
    {
        $dealers = DealerInfo::all();
        return view('dashboards.others.ledgerUpload', ['dealers' => $dealers]);
    }
    public function uploadLedger(Request $request)
    {
        $this->validate($request, [
            'file' => 'required|mimes:pdf|max:5000',
            'dealer' => 'required|exists:dealer_info,id'
        ]);

        $deal = DealerInfo::findorFail($request->dealer);

        $content = File::get($request->file('file'));

        $fileName = 'ledger/' . time() . '_' . $request->file->getClientOriginalName();

        if ($deal->ledger_file) {
            if (Storage::disk('public')->exists($deal->ledger_file)) {
                Storage::disk('public')->delete($deal->ledger_file);
            }
        }
        $upload = Storage::disk('public')->put($fileName, $content);

        if ($upload) {

            $deal->ledger_file = $fileName;
            $deal->ledger_update_date = date('Y-m-d H:i:s');

            Noticelog::create([
                'user_id' => $deal->code,
                'flag' => 'ledger',
                'title' => 'Ledger Uploaded.',
                'notice' => 'Ledger Uploaded.',
                'date' => date('Y-m-d'),
            ]);

            $deal->save();

            return redirect('/dashboard/ledgerview')
                ->with('Status', 'File has been uploaded.');
        } else {
            return back()
                ->with('Status', 'uploading Failed.');
        }
    }
    public function schemeView()
    {
        $dealer = DealerInfo::get();
        return view('dashboards.others.schemeAdd', ['dealers' => $dealer]);
    }

    public function uploadScheme(Request $request)
    {
        $request->validate([
            'title'       => 'required|string|max:255',
            'start_date'  => 'required|date_format:Y-m-d|after_or_equal:today',
            'end_date'    => 'required|date_format:Y-m-d|after:start_date',
            'file'        => 'required|mimes:pdf|max:4596',
            'dealer'      => 'nullable|exists:dealer_info,id',
            'scheme_type' => 'required|in:2,3',
        ]);

        $file = $request->file('file');
        $filePath = $file->storeAs('scheme', now()->timestamp . '_' . $file->getClientOriginalName(), 'public');

        $scheme = new Scheme([
            'dealerid'      => $request->dealer,
            'title'         => $request->title,
            'content'       => $request->content,
            'starting_from' => $request->start_date,
            'ending_on'     => $request->end_date,
            'image'         => $filePath,
            'type'          => $request->scheme_type,
            'status'        => '1',
            'publish'       => '0',
            'created_by'    => Auth::id(),
        ]);

        $scheme->save();

        $message = $request->scheme_type == 2
            ? 'Scheme has been created.'
            : 'Price List has been created.';

        return redirect('/dashboard/schemes')
            ->with('Status', $message);
    }


    public function schemes()
    {
        $schemes =  Scheme::where('status', '1')->whereIn('type', [2, 3])->get();
        foreach ($schemes as $scheme) {
            $user = DealerInfo::where('id', $scheme->dealerid)->first();
            if ($user) {
                $scheme->full_name = $user->firm_name;
            } else {
                $scheme->full_name = 'All';
            }
        }


        return view('dashboards.others.schemeView', ['schemes' => $schemes]);
    }
    public function editView($id)
    {
        $dealer = DealerInfo::get();
        $scheme = Scheme::findorFail($id);

        return view('dashboards.others.schemeEdit', ['scheme' => $scheme, 'dealers' => $dealer]);
    }
    public function editViewAdvertise($id)
    {

        $scheme = Scheme::where('id', $id)->first();
        return view('dashboards.others.advertiseedit', ['scheme' => $scheme]);
    }
    public function updateScheme(Request $request, $id)
    {
        $valid = Validator::make($request->all(), [
            'title' => 'required|string|max:255',
            'end_date' => 'required|date_format:Y-m-d|after:start_date',
            'start_date' => 'required|date_format:Y-m-d',
            'dealer' => 'nullable|exists:dealer_info,id',
            'scheme_type' => 'required|in:2,3'
        ]);
        if ($valid->fails()) {
            return back()->with('Status', "Warning - Cannot Update");
        }
        $scheme = Scheme::findorFail($id);

        // $oldDateUnix = strtotime($request['start_date']);
        // $currentYear = date('Y', $oldDateUnix);
        // $currentMonth = date('m', $oldDateUnix);
        // $currentDay = date('d', $oldDateUnix);
        // $engDay = $this->BS_to_AD($currentYear, $currentMonth, $currentDay);
        // $nepaliDay = $engDay['date'];
        // $c = strlen($nepaliDay);
        // if(!($c== 2)){
        //     $nepaliD = $engDay['date'];
        //     $nepaliDay =  '0'.$nepaliD;
        // }
        // $nepaliMth = $engDay['month'];
        // $nepaliYr = $engDay['year'];
        // $start = $nepaliYr . '-' . $nepaliMth . '-' . $nepaliDay;

        // $oldDateUnix = strtotime($request['end_date']);
        // $currentYear = date('Y', $oldDateUnix);
        // $currentMonth = date('m', $oldDateUnix);
        // $currentDay = date('d', $oldDateUnix);
        // $engDay = $this->BS_to_AD($currentYear, $currentMonth, $currentDay);
        // $nepaliDay = $engDay['date'];
        // $c = strlen($nepaliDay);
        // if(!($c== 2)){
        //     $nepaliD = $engDay['date'];
        //     $nepaliDay =  '0'.$nepaliD;
        // }
        // $nepaliMth = $engDay['month'];
        // $nepaliYr = $engDay['year'];
        // $end = $nepaliYr . '-' . $nepaliMth . '-' . $nepaliDay;

        $start = $request->start_date;
        $end = $request->end_date;

        $scheme->starting_from = $request->start_date;
        $scheme->title = $request->title;
        $scheme->ending_on = $request->end_date;
        $scheme->content = $request->body;
        $scheme->dealerid = $request->dealer;
        $scheme->type = $request->scheme_type;

        $scheme->save();

        if ($request->scheme_type == 2) {
            return redirect('/dashboard/schemes')->with('Status', 'Scheme has been Updated');
        }
        if ($request->scheme_type == 3) {
            return redirect('/dashboard/schemes')->with('Status', 'Price list has been Updated');
        }
    }


    public function updateAdvertise(Request $request, $id)
    {
        $valid = Validator::make($request->all(), [
            'title' => 'required|string|max:255',
            'end_date' => 'date_format:Y-m-d|after:start_date',
            'start_date' => 'date_format:Y-m-d|after_or_equal:today',
            'dealer' => 'nullable|exists:dealer_user_info,id',
            'url_link' => 'nullable|url'
        ]);
        if ($valid->fails()) {
            return back()->with('Status', "Warning - Cannot Update");
        }
        $scheme = Scheme::findorFail($id);

        $start = $request->start_date;
        $end = $request->end_date;

        $scheme->starting_from = $request->start_date;
        $scheme->title = $request->title;
        $scheme->ending_on = $request->end_date;
        $scheme->content = $request->body;
        $scheme->dealerid = $request->dealer;
        $scheme->url_link = $request->url_link;

        $scheme->save();

        return redirect('/dashboard/advertise')->with('Status', 'Advertisement has been Updated');
    }


    public function delete($id)
    {
        $scheme = Scheme::findorFail($id);
        $img = $scheme->image;
        $image_path = public_path() . '/storage/scheme/' . $img;
        if (file_exists($image_path)) {
            @unlink($image_path);
        }
        $scheme->delete();

        return back()->with('Status', 'Scheme has been Deleted');
    }

    public function addImage(Request $request)
    {
        $this->validate($request, [
            'title' => 'required|string|max:255',
            'end_date' => 'date_format:Y-m-d|after:start_date',
            'start_date' => 'date_format:Y-m-d|after_or_equal:today',
            'file' => 'required|mimes:jpg,jpeg,png|image',
            'url_link' => 'nullable|url'
        ]);

        $fileName = 'scheme/' . time() . '_' . $request->file->getClientOriginalName();
        $content = File::get($request->file('file'));
        $upload = Storage::disk('public')->put($fileName, $content);
        // dd($upload);
        $scheme = new Scheme();
        $scheme->title = $request->title;
        $scheme->content = $request->body;
        $scheme->starting_from = $request->start_date;
        $scheme->ending_on = $request->end_date;
        $scheme->image = $fileName;
        $scheme->url_link = $request->url_link;
        $scheme->type = '1';
        $scheme->status = '1';
        $scheme->publish = '0';
        $scheme->created_by = Auth::User()->id;

        $scheme->save();

        return redirect('dashboard/advertise')->with('Status', 'Advertisement has been created.');
    }

    public function showImages()
    {
        $schemes =  Scheme::where('status', '1')->where('type', '1')->get();

        return view('dashboards.others.showimage', ['schemes' => $schemes]);
    }
    public function addImageView()
    {
        return view('dashboards.others.imageSlider');
    }

    public function publish($id)
    {
        $scheme = Scheme::findorFail($id);

        $scheme->publish = '1';
        if ($scheme->type == 1) {
            $flag = "slider";
            $title = "New Advertisement Added.";
            $content = array('Title' => $scheme->title, 'Details' => $scheme->content);
            $notice = new NotificationController();
            // $notice->sendGroupNotification($title, $flag, $content);
            Noticelog::create([
                'user_id' => null,
                'flag' => 'slider',
                'title' => $scheme->title,
                'notice' => $scheme->content,
                'date' => date('Y-m-d'),
            ]);
        }
        if ($scheme->type == 2) {
            $flag = "scheme";
            $title = "New Scheme Added.";
            $content = array('Title' => $scheme->title, 'Details' => $scheme->content);
            $notice = new NotificationController();
            if ($scheme->dealerid) {
                $fcm_id = DealerUser::where('dealer_id', $scheme->dealerid)->pluck('fcm_id')->toArray();
                if (count($fcm_id) > 0) {
                    // $notice->individualNotificationSend($fcm_id, $title, $flag, $content);
                }
                Noticelog::create([
                    'user_id' => $scheme->dealerid,
                    'flag' => 'scheme',
                    'title' => $scheme->title,
                    'notice' => $scheme->content,
                    'date' => date('Y-m-d'),
                ]);
            } else {
                // $notice->sendGroupNotification($title, $flag, $content);
                Noticelog::create([
                    'user_id' => null,
                    'flag' => 'scheme',
                    'title' => $scheme->title,
                    'notice' => $scheme->content,
                    'date' => date('Y-m-d'),
                ]);
            }
        }
        if ($scheme->type == 3) {
            $flag = "pricelist";
            $title = "New Price List Added.";
            $content = array('Title' => $scheme->title, 'Details' => $scheme->content);
            $notice = new NotificationController();
            if ($scheme->dealerid) {
                $fcm_id = DealerUser::where('dealer_id', $scheme->dealerid)->pluck('fcm_id')->toArray();
                if (count($fcm_id) > 0) {
                    // $notice->individualNotificationSend($fcm_id, $title, $flag, $content);
                }
                Noticelog::create([
                    'user_id' => $scheme->dealerid,
                    'flag' => 'pricelist',
                    'title' => $scheme->title,
                    'notice' => $scheme->content,
                    'date' => date('Y-m-d'),
                ]);
            } else {
                // $notice->sendGroupNotification($title, $flag, $content);
                Noticelog::create([
                    'user_id' => null,
                    'flag' => 'pricelist',
                    'title' => $scheme->title,
                    'notice' => $scheme->content,
                    'date' => date('Y-m-d'),
                ]);
            }
        }


        $scheme->save();
        if ($scheme->type == 2) {

            return back()->with('Status', 'Scheme has been Published');
        }
        if ($scheme->type == 3) {

            return back()->with('Status', 'Price List has been Published');
        }
        return back()->with('Status', 'Advertisement has been Published');
    }
    public function schemedetail($id)
    {
        $scheme = Scheme::where('id', $id)->first();

        return view('dashboards.others.schemepopup', ['scheme' => $scheme]);
    }
    public function advertisedetail($id)
    {
        $advertise = Scheme::where('id', $id)->first();

        return view('dashboards.others.advertisepopup', ['advertise' => $advertise]);
    }
}
