<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\DealerUser;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Validator;

class PasswordController extends Controller
{
    public function passwordView($id){
        $user = DealerUser::findorFail($id);
        return view('dashboards.users.changePassword',['user'=>$user]);
        
    }

    public function changePass($id,Request $request){
        $v = validator::make($request->all(),[
            'password'=>'required|same:password_confirmation|max:255',
        ]);
        if($v->fails()){
            return back()->with('Status','Password Not matched');
        }
        $dealer = DealerUser::findorFail($id);

        $dealer->password = hash::make($request->password);
        $dealer->user_pass_o =  $request->password;

        $dealer->save();

        if($dealer->user_role=='1'){
            return redirect('/dashboard/mobileUser')->with('Status','Password Changed');
        }else{
            return redirect('/dashboard/staffonDealer')->with('Status','Password Changed');
        }
    }
}
