<?php

namespace App\Http\Controllers;

use App\Category;
use App\ProductSize;
use App\Size;
use Illuminate\Http\Request;
use App\Product;
use App\Noticelog;
use App\Http\Controllers\NotificationController;
use App\Productimage;
use Illuminate\Support\Facades\DB;
use Intervention\Image\Facades\Image;
use Maatwebsite\Excel\Facades\Excel;
use App\Imports\ProductImport;
use Illuminate\Support\Facades\Storage;

class ProductController extends Controller
{
    public function index()
    {
        //
        $products = Product::all();
        return view('dashboards.products.list')
            ->with('products', $products);
    }
    public function create()
    {
        //
        $data['categories'] = Category::all();
        $data['products'] = Product::all();
        return view('dashboards.products.new', $data);
    }
    public function store(Request $request)
    {
        $this->validate($request, [
            'name' => 'required|unique:products|max:191',
            'category_id' => 'required|integer|exists:categories,id',
            'image' => 'nullable|mimes:jpeg,png,jpg|image|max:2048',
        ]);
        $product = new Product;

        $product->name = $request['name'];
        $product->category_id = $request['category_id'];
        $product->image = null;

        $product->save();

        return redirect('/dashboard/products')->with('Status', 'New Product Added.');
    }

    public function final_store(Request $request)
    {
        $this->validate($request, [
            'product_name' => 'required|numeric',
            'product_size' => 'required|numeric',
            'product_price' => 'required|numeric',
            'image' => 'nullable|mimes:jpeg,png,jpg|image|max:2048',
        ]);
        $products = ProductSize::where('product_id', $request['product_name'])->where('size_id', $request['product_size'])->get();
        if (count($products) > 0) {
            return redirect('/dashboard/productsfinal')->with('Status', 'This product already has this variant');
        } else {
            $product = new  ProductSize();
            if (!empty($request->image)) {
                $pi = new Productimage();
                $file = $request->file('image');

                $filename = rand() . '.' . $file->getClientOriginalExtension();

                $originalPath = 'productImage/' . $filename;
                $thumbnailPath = 'thumbnail/' . $filename;

                Storage::disk('public')->putFileAs('productImage', $file, $filename);

                $image = Image::make($file->getPathname())->resize(100, 100, function ($constraint) {
                    $constraint->aspectRatio();
                });

                Storage::disk('public')->put($thumbnailPath, (string) $image->encode());

                $product->product_id =  $request['product_name'];
                $product->size_id = $request['product_size'];
                $product->price = $request['product_price'];
                $product->save();

                $newPro = ProductSize::where('product_id', $request['product_name'])->where('size_id', $request['product_size'])->where('price', $request['product_price'])->first();

                $pi->product_id = $newPro->id;
                $pi->image = $originalPath;
                $pi->thumbnail = $thumbnailPath;
                $pi->type = 0; //0->profile picture

                $pi->save();
            } else {

                $product->product_id =  $request['product_name'];
                $product->size_id = $request['product_size'];
                $product->price = $request['product_price'];
                $product->status = '1';

                $product->save();
            }
            Noticelog::create([
                'user_id' => null,
                'flag' => 'product',
                'title' => 'New Product Added',
                'notice' => 'New Product Added.',
                'date' => date('Y-m-d'),
            ]);
            // $title = 'New Product Added';
            // $flag = 'product';
            // $content = array('Title' => 'New Product Added', 'Details' => 'New Product Added.');

            // $notice = new NotificationController();
            // $notice->sendGroupNotification($title, $flag, $content);


            return redirect('/dashboard/productsfinal')->with('Status', 'Complete Product Details Added');
        }
    }


    public function edit($id)
    {
        $product = Product::findorFail($id);
        $categories = Category::all();
        return view('dashboards.products.edit', ['product' => $product, 'categories' => $categories]);
    }
    public function update(Request $request, $id)
    {
        $this->validate($request, [
            'name' => 'required|max:191',
            'category_id' => 'required|numeric|exists:categories,id',
        ]);

        $product = Product::findorFail($id);

        if ($request->name != $product->name) {
            $this->validate($request, [
                'name' => 'unique:products',
            ]);
        }

        $product->name = $request->input('name');
        $product->category_id = $request->input('category_id');
        $product->save();

        return redirect('/dashboard/products')->with('Status', 'Product Updated');
    }
    public function final()
    {
        $products = DB::table('product_size')
            ->join('products', 'product_size.product_id', 'products.id')
            ->join('sizes', 'product_size.size_id', 'sizes.id')
            ->select('product_size.id', 'products.name', 'sizes.size', 'product_size.price', 'product_size.status')
            ->get();
        foreach ($products as $product) {
            $p = Productimage::where('product_id', $product->id)->first();
            if (empty($p)) {
                $image = '';
            } else {
                $image = $p->image;
            }
            $all[] = array(
                'id' => $product->id,
                'name' => $product->name,
                'size' => $product->size,
                'price' => $product->price,
                'status' => $product->status,
                'image' => $image,
            );
        }
        // return $all;

        if (empty($all)) {
            $all = [];
            return view('dashboards.products.final', ['products' => $all]);
        } else {

            return view('dashboards.products.final', ['products' => $all]);
        }
    }

    public function final_create()
    {
        $product = Product::get();
        $size = Size::get();

        return view('dashboards.products.final_create', ['product' => $product, 'size' => $size]);
    }



    public function final_edit($id)
    {
        $product = Product::get();
        $size = Size::get();
        $productinfo = ProductSize::findorFail($id);

        return view('dashboards.products.final_edit', ['product' => $productinfo, 'size' => $size, 'productinfo' => $productinfo]);
    }

    public function final_update(Request $request, $id)
    {
        //
        $this->validate($request, [
            'variant' => 'required|integer',
            'price' => 'required|numeric',
            'image' => 'nullable|mimes:jpeg,png,jpg|image|max:2048',
        ]);

        $product = ProductSize::findorFail($id);

        if (!empty($request->image)) {
            $pi = Productimage::where('product_id', $id)->where('type', 0)->first();
            if (!empty($pi)) {
                $pi->type = 1;
                $pi->save();
            }

            $file = $request->file('image');

            $filename = rand() . '.' . $file->getClientOriginalExtension();

            $originalPath = 'productImage/' . $filename;
            $thumbnailPath = 'thumbnail/' . $filename;

            Storage::disk('public')->putFileAs('productImage', $file, $filename);

            $image = Image::make($file->getPathname())->resize(100, 100, function ($constraint) {
                $constraint->aspectRatio();
            });

            Storage::disk('public')->put($thumbnailPath, (string) $image->encode());

            $product->size_id = $request->input('variant');
            $product->price = $request->input('price');

            $p = new Productimage();
            $p->product_id = $id;
            $p->image = $originalPath;
            $p->thumbnail = $thumbnailPath;
            $p->type = 0;

            $p->save();
            $product->save();
        } else {

            $product->size_id = $request->input('variant');
            $product->price = $request->input('price');

            $product->save();
        }
        Noticelog::create([
            'user_id' => null,
            'flag' => 'product',
            'title' => 'Product Update',
            'notice' => 'Product Update.',
            'date' => date('Y-m-d'),
        ]);

        return redirect('/dashboard/productsfinal')->with('Status', 'Product Details Updated');
    }

    public function final_destroy($id)
    {
        //
        ProductSize::findorFail($id)->delete();
        return redirect('/dashboard/productsfinal')->with('Status', 'Product info Deleted.');
    }
    public function excelProduct(Request $request)
    {
        $this->validate($request, [
            'excel_file' => 'required|file|mimes:xlsx',
        ]);
        $file = $request->file('excel_file');
        Excel::import(new ProductImport, $file);
        return redirect('/dashboard/products')->with('Status', 'New Product Added.');
    }
    public function status(Request $request, $id)
    {

        $this->validate($request, [
            'status' => 'required|integer',
        ]);
        $productinfo = ProductSize::findorFail($id);
        $productinfo->status = $request->status;
        $productinfo->save();

        Noticelog::create([
            'user_id' => null,
            'flag' => 'product',
            'title' => 'Product Status Update',
            'notice' => 'Product Status Update.',
            'date' => date('Y-m-d'),
        ]);

        if ($request->status == 1) {
            $title = 'Product Status';
            $flag = 'product';
            $content = array('Title' => 'Product Status', 'Details' => 'Product Enable.');

            $notice = new NotificationController();
            // $notice->sendGroupNotification($title, $flag, $content);
            return redirect('/dashboard/productsfinal')->with('Status', 'Product Enabled.');
        } else {
            $title = 'Product Status';
            $flag = 'product';
            $content = array('Title' => 'Product Status', 'Details' => 'Product Disabled.');

            $notice = new NotificationController();
            // $notice->sendGroupNotification($title, $flag, $content);
            return redirect('/dashboard/productsfinal')->with('Status', 'Product Disable.');
        }
    }
    public function viewImage($id)
    {
        $product = ProductSize::findorFail($id);
        return view('dashboards.products.imageAddView', ['product' => $product]);
    }

    public function imageSave(Request $request)
    {
        // return $request->all();
        $this->validate($request, [
            'product_id' => 'required|integer|exists:product_size,id',
            'image.*' => 'required|mimes:jpeg,jpg,png|image|max:2048',
        ]);

        foreach ($request->file('image') as $file) {
            $filename = rand() . '.' . $file->getClientOriginalExtension();

            $originalPath = 'productImage/' . $filename;
            $thumbnailPath = 'thumbnail/' . $filename;

            $file->storeAs('productImage', $filename, 'public');

            $image = Image::make($file->getPathname())->resize(100, 100, function ($constraint) {
                $constraint->aspectRatio();
            });

            Storage::disk('public')->put($thumbnailPath, (string) $image->encode());

            // Save to database
            Productimage::create([
                'product_id' => $request->product_id,
                'image' => $originalPath,
                'thumbnail' => $thumbnailPath,
                'type' => 1,
            ]);
        }
        return redirect('/dashboard/productsfinal')->with('Status', 'image Upload successfull.');
    }

    public function imgView($id)
    {
        ProductSize::findorFail($id);
        $images = Productimage::where('product_id', $id)->get();
        return view('dashboards.products.viewImg', ['images' => $images]);
    }

    public function unlink($id)
    {
        $img = Productimage::findorFail($id);
        $image_path = public_path() . '/productImage/' . $img->image;
        $thmb = public_path() . '/thumbnail/' . $img->image;
        if (file_exists($image_path)) {

            @unlink($image_path);
            @unlink($thmb);
        }
        $img->delete();
        return  redirect('dashboard/product/images/' . $img->product_id . '/all')->with('Status', 'Image Deleted');
    }
}
