<?php

namespace App\Http\Controllers;

use App\ProductDetail;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Storage;

class ProductDetailController extends Controller
{
    public function index()
    {
        $data['productDetails'] = ProductDetail::whereNotNull('name')->get();
        return view('dashboards.productDetails.index', $data);
    }

    public function edit($id)
    {
        $data['productDetail'] = ProductDetail::find($id);
        return view('dashboards.productDetails.edit', $data);
    }


    public function update(Request $request, $id)
    {
        $request->validate([
            'product_name' => 'required',
            'coverageFt2PerGallon' => 'required',
            // 'product_price' => 'required',
            'product_image' => 'nullable|image|mimes:jpeg,png,jpg,gif,svg|max:2048',
        ]);

        $productDetail = ProductDetail::find($id);
        $productDetail->name = $request->input('product_name');
        $productDetail->coverageFt2PerGallon = $request->input('coverageFt2PerGallon');
        // $productDetail->price = $request->input('product_price');

        if ($request->hasFile('product_image')) {
            if ($productDetail->image && Storage::disk('public')->exists($productDetail->image)) {
                Storage::disk('public')->delete($productDetail->image);
            }

            $image = $request->file('product_image');
            $imageName = 'product_details/' . time() . '.' . $image->getClientOriginalExtension();

            Storage::disk('public')->put($imageName, file_get_contents($image));

            $productDetail->image = $imageName;
        }


        $productDetail->save();

        return redirect()->route('product-details.index')->with('success', 'Product Detail updated successfully.');
    }
}
