<?php

namespace App\Http\Controllers;

use App\Size;
use Illuminate\Http\Request;

class SizeController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
        $sizes = Size::all();
        return view('dashboards.size.list')
            ->with('sizes', $sizes);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
        return view('dashboards.size.create');
    }

    public function store(Request $request)
    {
        //
        $this->validate($request, [
            'size' => 'required|unique:sizes',
        ]);

        Size::create([
            'size' => $request['size'],
        ]);

        return redirect('/dashboard/products-size')->with('Status', 'New Size Added.');
    }

    public function edit($id)
    {
        //
        $size = Size::findorFail($id);
        return view('dashboards.size.edit', compact('size'));
    }

    public function update(Request $request, $id)
    {
        //
        $this->validate($request, [
            'variant' => 'required|unique:sizes,id',
        ]);

        $size = Size::findorFail($id);

        $size->size = $request->input('variant');

        $size->save();
        return redirect('/dashboard/products-size')->with('Status', 'Size Updated.');
    }
}
