<?php

namespace App\Http\Controllers;

use App\TaxMetaInfo;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Session;
use App\Noticelog;
use App\Utilities\Helpers;

class TaxMetaInfoController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $data['meta'] = TaxMetaInfo::first();

        return view('dashboards.colorants.colorant-meta', $data);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->validate($request, [
            'vat' => 'numeric|required',
            'mark_up' => 'numeric|required'
        ]);
        $meta = TaxMetaInfo::first();
        if (!$meta) {
            $meta = new TaxMetaInfo();
        }
        $meta->vat_percentage = $request->vat;
        $meta->mark_up_percentage = $request->mark_up;

        Noticelog::create([
            'user_id' => null,
            'flag' => 'colorant',
            'title' => 'Colourant Tax and Mark Up Price Updated',
            'notice' => 'Colourant Tax and Mark Up Price has been updated by Company.',
            'date' => date('Y-m-d'),
        ]);

        if ($meta->save()) {
            $flag = "colorant";
            $title = "Colourant tax and mark Up price Updated.";
            $content = array('Title' => 'Colourant tax and mark Up price Updated.', 'Details' => 'Colourant tax and mark Up price Updated.');
            $notice = new NotificationController();
            // $notice->sendGroupNotification($title, $flag, $content);
        }

        $data = [
            'route_channel' => 'colorant',
            'file_path' => null,
        ];

        $title = $colorant->title ?? 'Colourant tax and mark Up price Updated.';
        $body = $colorant->description ?? 'Colourant tax and mark Up price Updated by Company.';

        $helpers = new Helpers;

        $helpers->runFirebaseNotification(null, 'all', $title, $body, $data);

        Session::flash('Status', 'Colourant Meta info Updated');
        return back();
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\TaxMetaInfo  $taxMetaInfo
     * @return \Illuminate\Http\Response
     */
    public function show(TaxMetaInfo $taxMetaInfo)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\TaxMetaInfo  $taxMetaInfo
     * @return \Illuminate\Http\Response
     */
    public function edit(TaxMetaInfo $taxMetaInfo)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\TaxMetaInfo  $taxMetaInfo
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, TaxMetaInfo $taxMetaInfo)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\TaxMetaInfo  $taxMetaInfo
     * @return \Illuminate\Http\Response
     */
    public function destroy(TaxMetaInfo $taxMetaInfo)
    {
        //
    }
}
