<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\User;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Validator;

class UserController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
        $users = User::all();
        return view('dashboards.admins.admin-index')
            ->with('users', $users);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function showRegisterForm()
    {
        //
        return view('dashboards.admins.admin-create');
    }

    public function register(Request $request)
    {
        //
        $this->validate($request, [
            'full_name' => 'required|max:255',
            'email' => 'required|email|unique:users|max:255',
            'phone' => 'required|numeric|unique:users|digits_between:9,10',
            'password' => 'required|confirmed|max:255',
            'address' => 'required|max:255',
            'role' => 'required|max:255'
        ]);
        // return $request->full_name;
        //        User::create($request->all());
        //        return redirect('/dashboard')->with('Status','New Admin created.');
        $user = new User();

        // User::create([
        $user->full_name = $request->full_name;
        $user->email = $request->email;
        $user->phone = $request->phone;
        $user->user_role = $request->role;
        $user->address = $request->address;
        $user->password = Hash::make($request->password);
        $user->status = '1';
        $user->save();
        // ]);
        return redirect('/dashboard/admins')->with('Status', 'New Admin created.');
    }
    public function validation($request)
    {
        return $this->validate($request, [
            'full_name' => 'required|max:255',
            'email' => 'required|email|unique:users|max:255',
            'phone' => 'required|numeric|unique:users|digits_between:9,10',
            'password' => 'required|confirmed|max:255',
            'address' => 'required|max:255',
            'role' => 'required|max:255'
        ]);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
        $user = User::findorFail($id);
        return view('dashboards.admin-profile', compact('user'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
        $user = User::findorFail($id);
        return view('dashboards.admins.admin-edit', compact('user'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
        $this->validate($request, [
            'name' => 'required|max:255',
            'email' => 'required|email|unique:users,id',
            'phone' => 'required|numeric|unique:users,id|digits_between:9,10',
        ]);

        $user = User::findorFail($id);

        $user->full_name = request('name');
        $user->email = request('email');
        $user->phone = request('phone');

        $user->save();
        return redirect('/dashboard/admins')->with('Status', 'Admin Details Updated.');
    }

    public function change($id)
    {
        //
        $user = User::findorFail($id);
        return view('dashboards.admins.admin-password', compact('user'));
    }

    public function changepass(Request $request, $id)
    {
        //
        $user = User::findorFail($id);
        $this->validate($request, [
            'password' => 'required|confirmed|max:255',
        ]);
        if (Hash::check($request['old_password'], $user->password)) {

            $pass = Hash::make($request['password']);
            $user->password = $pass;
            $user->save();
            //            $user->update(['password' => $pass]);
            return redirect('/dashboard/admins')->with('Status', 'Password Changed.');
        } else {
            return redirect('/dashboard/admins')->with('Status', 'Password not Match.');
        }
    }
}
