<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class ImageAsset extends Model
{
    protected $fillable = [
        'dealer_id',
        'client_id',
        'type',
        'original_filename',
        'filename',
        'index',
    ];

    protected $casts = [
        'index' => 'integer',
    ];

    protected $hidden = [
        'dealer_id',
        'client_id',
        'created_at',
        'updated_at',
        'index',
    ];

    protected static function boot()
    {
        parent::boot();

        static::creating(function ($model) {
            if (is_null($model->index)) {
                $last = static::orderByDesc('index')->first();
                $model->index = $last ? ($last->index + 1) : 1;
            }
        });
    }

    public function dealer()
    {
        return $this->belongsTo(DealerInfo::class, 'dealer_id');
    }

    public function client()
    {
        return $this->belongsTo(Client::class, 'client_id');
    }
}
