<?php

namespace App\Imports;

use Illuminate\Support\Collection;
use Maatwebsite\Excel\Concerns\ToCollection;
use Maatwebsite\Excel\Concerns\ToModel;
use Maatwebsite\Excel\Concerns\WithHeadingRow;
use Illuminate\Validation\ValidationException;
use App\DealerInfo;
use App\DealerUser;
use App\Noticelog;
use App\Http\Controllers\NotificationController;

class Dueimport implements ToModel,WithHeadingRow
{
    /**
    * @param Collection $collection
    */
    public function model(array $row)
    {
        if(!empty($row['id']) && !empty($row['Name']) && !empty($row['dealer_code']) && !empty($row['due_amount']) && !empty($row['cheque_in_hand'] && !empty($row['no_of_cheque'])) ){
            $dealer = DealerInfo::where('code',$row['id'])->first();

            if($dealer){

                $title = "Due Amount";
                $flag = 'chequeAndDue';
                $detail = "Deu amount Updated.";
                $content = array('Title'=>'Deu amount Updated.', 'Details' => 'Deu amount Updated.');
                // $notice = new NotificationController();

                $dealer->cheque_nos = $row['no_of_cheque'];
                $dealer->cheque_in_hand = $row['cheque_in_hand'];
                $dealer->due_amount = $row['due_amount'];

                $dealer->save();
                }
            
        }else{
            throw ValidationException::withMessages(['email' => 'dealer_code ,due_amt, no_of_cheque cannot be empty.']);
        }
        
    }
}
