<?php

namespace App\Imports;

use Illuminate\Support\Collection;
use Maatwebsite\Excel\Concerns\ToCollection;
use Maatwebsite\Excel\Concerns\ToModel;
use Maatwebsite\Excel\Concerns\WithHeadingRow;
use App\Product;
use App\Category;
use App\ProductSize;
use App\Size;
use Illuminate\Validation\ValidationException;

class ProductImport implements ToModel,WithHeadingRow
{
    /**

    * @param array $row

    *

    * @return \Illuminate\Database\Eloquent\Model|null

    */
    public function model(array $row)
    {

         if(!empty($row['product_name'])||!empty($row['category_name'])||!empty($row['variants'])||!empty($row['price'])){
                $cat = Category::where('name',$row['category_name'])->first();
                if(!$cat){
                    $cat = Category::create([
                        'name' => $row['category_name'],
                    ]);
                }
                $product = Product::where('name',$row['product_name'])->first();
                if(!$product){
                $product = Product::create([
                    'name' => $row['product_name'],
                    'category_id' => $cat->id,
                ]);
                }
                $size = Size::where('size',$row['variants'])->first();
                if(!$size){
                $size = Size::create([
                    'size' => $row['variants'],
                ]);
                }
                // $sub = Subproduct::where('sub_product',$row['subproduct'])->first();
                // if(!$sub){
                //     $sub = Subproduct::create([
                //         'product_id' => $product->id,
                //         'sub_product' => $row['subproduct'],
                //     ]);
                //     }

                $final = ProductSize::where('product_id',$product->id)->where('size_id',$size->id)->first();
                if(!$final){
                $final = ProductSize::create([
                    'product_id' => $product->id,
                    // 'subid' => $sub->id,
                    'size_id' => $size->id,
                    'price' => $row['price'],
                    'status' => '1',
                ]);
                }
            }else{
                    throw ValidationException::withMessages(['email' => 'Column cannot be empty.']);
                }

    }
}
