<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use DateTimeInterface;
class Message extends Model
{
    protected $fillable = [
        'from','to','message','is_read'
    ];
    public function mesaage_image(){
        return $this->hasMany('App\MessageImages','chat_id');
    }
    public function dealerinfo(){
        return $this->belongsTo('App\DealerUser','from');
    }
    public function user(){
        return $this->belongsTo('App\User','admin');
    }
    public function group(){
        return $this->belongsTo('App\MessageGroup');
    }
    protected function serializeDate(DateTimeInterface $date)
    {
        return $date->format('Y-m-d H:i:s');
    }
}
