<?php

namespace App\Observers;

use App\DealerInfo;
use App\DealerUser;
use App\Utilities\Helpers;

class LederObserver
{
    public function updated(DealerInfo $dealerInfo): void
    {
        if ($dealerInfo->isDirty('ledger_file')) {
            $data = [
                'route_channel' => 'ledger',
                'file_path' => $dealerInfo->ledger_file ?? null,
            ];

            $title = $dealerInfo->title ?? 'Ledger Update';
            $body = $dealerInfo->description ?? 'New ledger has been updated';

            $helpers = new Helpers;

            $fcmids = DealerUser::where('user_code', $dealerInfo->dealer_code)->pluck('fcm_id')->toArray();
            foreach ($fcmids as $fcmid) {
                if ($fcmid) {
                    $helpers->runFirebaseNotification($fcmid, null, $title, $body, $data);
                }
            }
        }
    }
}
