<?php

namespace App\Observers;

use App\DealerUser;
use App\Notice;
use App\Utilities\Helpers;

class NoticeObserver
{
    public function updated(Notice $notice): void
    {
        if ($notice->isDirty('publish') && $notice->publish == 1) {
            $data = [
                'route_channel' => 'notice',
                'file_path' => null,
            ];

            $title = $notice->title;
            $body = $notice->description ?? 'You have a new notice';

            $helpers = new Helpers;

            if ($notice->user_id == '') {
                $helpers->runFirebaseNotification(null, 'all', $title, $body, $data);
            } else {
                $fcmid = DealerUser::where('dealer_id', $notice->user_id)->first()->fcm_id;
                $helpers->runFirebaseNotification($fcmid, null, $title, $body, $data);
            }
        }
    }
}
