<?php

namespace App\Observers;

use App\DealerUser;
use App\Order;
use App\Utilities\Helpers;

class OrderObserver
{
    public function updated(Order $order): void
    {
        if ($order->isDirty('status')) {
            $data = [
                'route_channel' => 'order',
                'file_path' => null,
            ];

            $title = $order->title ?? 'Order Status Update';
            $body = $order->description ?? 'Your order status has been updated';

            $helpers = new Helpers;

            if ($order->user_id) {
                $fcmid = DealerUser::where('dealer_id', $order->user_id)->value('fcm_id');
                if (!empty($fcmid)) {
                    $helpers->runFirebaseNotification($fcmid, null, $title, $body, $data);
                }
            }
        }
    }
}
