<?php

namespace App\Observers;

use App\ProductSize;
use App\Utilities\Helpers;

class ProductObserver
{
    public function updated(ProductSize $productSize): void
    {
        if ($productSize->isDirty()) {
            $data = [
                'route_channel' => 'product',
                'file_path' => null,
            ];

            $title = $productSize->product->name ?? "Product";
            $body = $productSize->description ?? 'Product Update';

            $helpers = new Helpers;

            $helpers->runFirebaseNotification(null, 'all', $title, $body, $data);
        }
    }
}
