<?php

namespace App\Observers;

use App\DealerUser;
use App\Scheme;
use App\Utilities\Helpers;

class SchemePriceListObserver
{
    public function updated(Scheme $scheme): void
    {
        if ($scheme->isDirty('publish') && $scheme->publish == '1') {
            $isAdvertisement = $scheme->type === 1;
            $isScheme = $scheme->type === 2;
            $isPriceList = $scheme->type === 3;

            $routeChannel = $isAdvertisement ? 'advertisement' : ($isScheme ? 'scheme' : 'pricelist');
            $data = [
                'route_channel' => $routeChannel,
                'file_path' => $isAdvertisement ? $scheme->url_link : $scheme->image,
            ];

            $title = $scheme->title ?? ucfirst($routeChannel) . ' Update';
            $body = $scheme->description ?? 'New ' . $routeChannel . ' has been updated';

            $helpers = new Helpers;

            if ($scheme->dealerid === null) {
                $helpers->runFirebaseNotification(null, 'all', $title, $body, $data);
            } else {
                $fcmid = DealerUser::where('dealer_id', $scheme->dealerid)->first()->fcm_id;
                $helpers->runFirebaseNotification($fcmid, null, $title, $body, $data);
            }
        }
    }
}
