<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Order extends Model
{
    protected $table = 'orders';

    protected $fillable = [
        'dealer_code',
        'user_id',
        'date',
        'status',
    ];

    public function dealer()
    {
        return $this->belongsTo('App\DealerInfo', 'dealer_code', 'id');
    }

    public function user()
    {
        return $this->belongsTo('App\DealerUser', 'user_id', 'id');
    }

    public function items()
    {
        return $this->hasMany('App\Orderitem');
    }
}
