<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Orderitem extends Model
{
    protected $fillable = [
        'order_id',
        'items_id',
        'quantity',
        'updated_quantity',
        'status',
        'discount_rate',
        'discount_amount',
        'items_price_rate',
        'price'
    ];

    public function order()
    {
        return $this->belongsTo('App\Order');
    }

    public function items()
    {
        return $this->belongsTo(ProductSize::class, 'items_id');
    }
}
