<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class ProductSize extends Model
{
    protected $table = "product_size";

    //
    protected $fillable = [
        'product_id', 'size_id', 'price','status'
    ];

    public function product(){
        return $this->belongsTo('App\Product');
    }

    public function size(){
        return $this->belongsTo('App\Size');
    }
    
    public function category(){
        return $this->belongsTo('App\Category','category_id');
    }
}
