<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;
use Illuminate\Support\Facades\Schema;
use Mockery\Matcher\Not;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     *
     * @return void
     */
    public function register()
    {
        //
    }

    /**
     * Bootstrap any application services.
     *
     * @return void
     */
    public function boot()
    {
        Schema::defaultStringLength(191);
        \App\Notice::observe(\App\Observers\NoticeObserver::class);
        \App\Order::observe(\App\Observers\OrderObserver::class);
        \App\DealerInfo::observe(\App\Observers\LederObserver::class);
        \App\Scheme::observe(\App\Observers\SchemePriceListObserver::class);
        \App\ProductSize::observe(\App\Observers\ProductObserver::class);
    }
}
