<?php

namespace App\Providers;

use Illuminate\Foundation\Support\Providers\RouteServiceProvider as ServiceProvider;
use Illuminate\Support\Facades\Route;

class RouteServiceProvider extends ServiceProvider
{
    /**
     * This namespace is applied to your controller routes.
     *
     * In addition, it is set as the URL generator's root namespace.
     *
     * @var string
     */
    protected $namespace = 'App\Http\Controllers';
    protected $namespacev1 = 'App\Http\Controllers\API';
    protected $namespacev2 = 'App\Http\Controllers\API\V2';
    protected $namespacev3 = 'App\Http\Controllers\API\V3';

    /**
     * The path to the "home" route for your application.
     *
     * @var string
     */
    public const HOME = '/dashboard';

    /**
     * Define your route model bindings, pattern filters, etc.
     *
     * @return void
     */
    public function boot()
    {
        //

        parent::boot();
    }

    /**
     * Define the routes for the application.
     *
     * @return void
     */
    public function map()
    {
        $this->mapApiRoutes();
        // $this->mapApiV2Routes();
        // $this->mapApiV3Routes();

        $this->mapWebRoutes();

        //
    }

    /**
     * Define the "web" routes for the application.
     *
     * These routes all receive session state, CSRF protection, etc.
     *
     * @return void
     */
    protected function mapWebRoutes()
    {
        Route::middleware('web')
            ->namespace($this->namespace)
            ->group(base_path('routes/web.php'));
    }

    /**
     * Define the "api" routes for the application.
     *
     * These routes are typically stateless.
     *
     * @return void
     */
    protected function mapApiRoutes()
    {
        Route::prefix('api')
            ->middleware('api')
            ->namespace($this->namespacev1)
            ->group(base_path('routes/api.php'));
    }

    // protected function mapApiV2Routes()
    // {
    //     Route::prefix('api/v2')
    //         ->middleware('api')
    //         ->namespace($this->namespacev2)
    //         ->group(base_path('routes/api/v2.php'));
    // }

    // protected function mapApiV3Routes()
    // {
    //     Route::prefix('api/v3')
    //         ->middleware('api')
    //         ->namespace($this->namespacev3)
    //         ->group(base_path('routes/api/v3.php'));
    // }
}
