<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Size extends Model
{
    //
    protected $fillable = [
        'size',
        'order_index'
    ];

    protected static function boot()
    {
        parent::boot();

        static::creating(function ($model) {
            if (is_null($model->order_index)) {
                $last = static::orderByDesc('order_index')->first();
                $model->order_index = $last ? ($last->order_index + 1) : 1;
            }
        });
    }

    public function product()
    {
        return $this->belongsToMany('App\Product', 'product_size', 'size_id', 'product_id');
    }
}
