<?php

/*
* To change this license header, choose License Headers in Project Properties.
* To change this template file, choose Tools | Templates
* and open the template in the editor.
*/

/**
 * Description of FCM
 *
 * @author sushil
 */

namespace App\Traits;

use App\Mobileuser;
use GuzzleHttp\Client;

trait FCM {

    function sendGroupNotification($flag, $title, $content) {

        $client = new Client();

        $res = $client->request('POST', config('app.NotificationAppUrl') . '/topicmessage', [
                'headers' =>
                    [
                        'Content-Type' => "application/x-www-form-urlencoded"
                    ],
                'form_params' =>
                    [
                        // 'schoolid' => $schoolid,
                        'flag'=>$flag,
                        'title' => $title,
                        'body' => $content,
                        'tag' => 'na',
                        'authKey' => config('app.FCMAuth')
                    ]
            ]
        );
        if ($res->getStatusCode() === 200) {
            return true;
        } else {
            return false;
        }
    }

    function sendIndividualNotification($fcmid,$title,$flag,$content){


        $client = new Client();

        $res = $client->request('POST', config('app.NotificationAppUrl') . '/studentmessage', [
                'headers' =>
                    [
                        'Content-Type' => "application/x-www-form-urlencoded"
                    ],
                'form_params' =>
                    [
                        'fcmid' => $fcmid,
                        'title' => $title,
                        'body' => $content,
                        'flag'=>$flag,
                        'tag' => 'na',
                        'authKey' => config('app.FCMAuth')
                    ]
            ]
        );
        if ($res->getStatusCode() === 200) {
            return true;
        } else {
            return false;
        }

    }


    function unique_multidim_array($array, $key) {
        $temp_array = array();
        $i = 0;
        $key_array = array();

        foreach($array as $val) {
            if (!in_array($val[$key], $key_array)) {
                $key_array[$i] = $val[$key];
                $temp_array[$i] = $val;
            }
            $i++;
        }
        return $temp_array;
    }

}