<?php

namespace App\Utilities;

use Google_Client;

class Helpers
{

    public function runFirebaseNotification($fcmid, $topic, $title, $body, $data)
    {
        $isProduction = config('app.env') === 'production';
        $projectId = $isProduction ? config('app.prod-fcm_project_id') : config('app.dev-fcm_project_id');
        $credentialsPath = $isProduction ? config('app.prod-fcm_json') : config('app.dev-fcm_json');
        $url = "https://fcm.googleapis.com/v1/projects/{$projectId}/messages:send";

        if (!$projectId || !$credentialsPath) {
            return false;
        }

        $client = new Google_Client();
        $client->setAuthConfig($credentialsPath);
        $client->addScope('https://www.googleapis.com/auth/firebase.messaging');

        $token = $client->fetchAccessTokenWithAssertion();
        if (!isset($token['access_token'])) {
            throw new \Exception('Failed to fetch access token from Firebase.');
        }

        $headers = [
            'Authorization: Bearer ' . $token['access_token'],
            'Content-Type: application/json',
        ];

        // Build the message payload
        $message = [];

        if ($fcmid) {
            $message['token'] = $fcmid;
        }
        if ($topic) {
            $message['topic'] = $topic;
        }
        if ($title && $body) {
            $message['notification'] = [
                'title' => $title,
                'body'  => $body,
            ];
        }
        if ($data) {
            $message['data'] = $data;
        }

        // Add Android-specific options
        $message['android'] = [
            'priority' => 'high',
            'notification' => [
                'sound' => 'default',
                'click_action' => 'FLUTTER_NOTIFICATION_CLICK', // or your app-specific intent
            ],
        ];

        // Add iOS-specific (APNs) options
        $message['apns'] = [
            'headers' => [
                'apns-priority' => '10',
            ],
            'payload' => [
                'aps' => [
                    'sound' => 'default',
                    'content-available' => 1,
                ],
            ],
        ];


        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode(['message' => $message]));

        $response = curl_exec($ch);
        if ($response === false) {
            $error = curl_error($ch);
            curl_close($ch);
            throw new \Exception("Curl error: {$error}");
        }
        curl_close($ch);
    }
}
