@extends('dashboards.blank')

@section('content')
<style>
    .dt-buttons {
        display: none;
    }
    .custom-checkbox{
        height:20px;
        width:20px;
        margin-top:0;
    }
    .item-center{
        display: flex;
        align-items: center;
    }
    .item-cont>:not(:first-child){
        margin-top:10px;
    }
    .item-container{
        max-height:150px;
        overflow: auto;;
    }
    .font-bold{
        margin-left: 16px;
        font-weight:bold;
    }
</style>
<div class="page-content">
    <div class="breadcrumbs">
        <h1>Group Chat </h1>
        <!-- Sidebar Toggle Button -->
        <button type="button" class="navbar-toggle" data-toggle="collapse" data-target=".page-sidebar">
            <span class="sr-only">Toggle navigation</span>
            <span class="toggle-icon">
                <span class="icon-bar"></span>
                <span class="icon-bar"></span>
                <span class="icon-bar"></span>
            </span>
        </button>
        <!-- Sidebar Toggle Button -->
    </div>

    <div class="page-content-container">
        <div class="page-content-row" id="replecable">
            <div class="page-sidebar">
                <div class="portlet light portlet-fit">
                    <div class="portlet-title">
                        <div class="caption">
                            <i class=" icon-bar font-red"></i>
                            <span class="caption-subject font-red bold uppercase">Quick Navigation</span>
                        </div>

                    </div>
                    <nav class="navbar" role="navigation">
                        <!-- Brand and toggle get grouped for better mobile display -->
                        <!-- Collect the nav links, forms, and other content for toggling -->
                        <ul class="nav navbar-nav margin-bottom-35 bank-class">
                            <li><a href="/dashboard/chat-group/create">Create Group </a></li>
                            <li><a href="/dashboard/chat-group">View Group</a></li>
                            <li class="active"><a href="/dashboard/chat-group/{{$messageGroup->id}}/edit">Edit Group</a></li>
                        </ul>
                    </nav>
                </div>

            </div>
            <div class="page-content-col">

                @if(session('Status'))
                <div class="alert alert-success alert-dismissible" role="alert">
                    <b>{{ session('Status') }}</b>
                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                @endif

                <div class="row">
                    <div class="col-md-7">
                        <!-- BEGIN EXAMPLE TABLE PORTLET-->
                        <div class="portlet light portlet-fit bordered">
                            <div class="portlet-title">
                                <div class="caption">
                                    <i class="fa fa-upload font-red"></i>
                                    <span class="caption-subject font-red bold uppercase">Group Information</span>
                                </div>

                            </div>

                            @if(count($errors) > 0)
                            @foreach($errors->all() as $error)
                            <p class="alert alert-danger">{{ $error }}</p>
                            @endforeach
                            @endif

                            <form action="/dashboard/chat-group/{{$messageGroup->id}}" method="post" enctype="multipart/form-data">
                                @csrf
                                @method('PATCH')
                                <div class="form-group row">
                                    <label for="fileupload" class="col-md-3 col-form-label text-right">Group Name *</label>
                                    <div class="col-md-8">
                                        <input class="form-control" type="input" name="group_name"value="{{$messageGroup->group_name}}" placeholder="Group Name" required>
                                    </div>
                                </div>
                        </div>
                        <div class="portlet light portlet-fit bordered">
                            <div class="portlet-title">
                                <div class="caption">
                                    <i class="fa fa-upload font-red"></i>
                                    <span class="caption-subject font-red bold uppercase">Dealer User</span>
                                </div>

                            </div>
                            <div class="form-group row">
                                <label class="col-md-3 col-form-label text-left font-bold">Dealer:</label>
                                <div class="col-md-8 item-container">
                                    <div class="item-cont">
                                    @foreach($users as $user)
                                    <div class="item-center">
                                    <input id="id{{$user->id}}" type="checkbox" class="custom-checkbox" value="{{$user->id}}" name="mo_user[]" id="" @foreach($messageGroup->groupuser as $g_user) @if($g_user->user_id==$user->id && $g_user->user_type=='user') checked @endif @endforeach>
                                    <label for="id{{$user->id}}" style="margin-left:10px;">{{$user->full_name}}</label>
                                    </div>
                                    @endforeach
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="portlet light portlet-fit bordered">
                            <div class="portlet-title">
                                <div class="caption">
                                    <i class="fa fa-upload font-red"></i>
                                    <span class="caption-subject font-red bold uppercase">Add Admin User</span>
                                </div>
                            </div>
                            <div class="form-group row">
                                <label class="col-md-3 col-form-label text-left font-bold">Admin User:</label>
                                <div class="col-md-8 item-container">
                                <div class="item-cont">
                                @foreach($admins as $admin)
                                <div class="item-center">
                                    <input id="admin{{$admin->id}}" type="checkbox" class="custom-checkbox" name="admin_user[]" value="{{$admin->id}}" @foreach($messageGroup->groupuser as $g_user) @if($g_user->user_id==$admin->id && $g_user->user_type=='admin') checked @endif @endforeach>
                                    <label for="admin{{$admin->id}}" style="margin-left:10px;">{{$admin->name}}</label>
                                    </div>
                                @endforeach
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-5">
                        <!-- BEGIN EXAMPLE TABLE PORTLET-->
                        <div class="portlet light portlet-fit bordered">
                            <div class="portlet-title">
                                <div class="caption">
                                    <span class="caption-subject font-red bold uppercase">Action</span>
                                </div>

                            </div>
                            <div class="form-group row">
                                <label for="status" class="col-md-3 col-form-label text-right">Status *</label>
                                <div class="col-md-8">
                                    <select name="status" id="" class="form-control" required>
                                        <option value="Active" @if($messageGroup->status=='Active') selected @endif>Active</option>
                                        <option value="Inactive" @if($messageGroup->status=='Inactive') selected @endif> Inactive</option>
                                    </select>
                                </div>
                            </div>
                            <div class="form-group">
                                <button class="btn btn-primary" style="margin-left:16px;width:150px"> Update </button>
                            </div>
                        </div>
                    </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

@endsection